/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SecurityProfileIdentifierMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final SecurityProfileIdentifierMarshaller INSTANCE = new SecurityProfileIdentifierMarshaller();

    private SecurityProfileIdentifierMarshaller() {
    }

    public static SecurityProfileIdentifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecurityProfileIdentifier securityProfileIdentifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)securityProfileIdentifier, (String)"securityProfileIdentifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)securityProfileIdentifier.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)securityProfileIdentifier.arn(), ARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

