/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.StreamSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamSummaryMarshaller {
    private static final MarshallingInfo<String> STREAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamId").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamArn").isBinary(false).build();
    private static final MarshallingInfo<Integer> STREAMVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamVersion").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final StreamSummaryMarshaller INSTANCE = new StreamSummaryMarshaller();

    private StreamSummaryMarshaller() {
    }

    public static StreamSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamSummary streamSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)streamSummary, (String)"streamSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)streamSummary.streamId(), STREAMID_BINDING);
            protocolMarshaller.marshall((Object)streamSummary.streamArn(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)streamSummary.streamVersion(), STREAMVERSION_BINDING);
            protocolMarshaller.marshall((Object)streamSummary.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

