/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ThingAttribute;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ThingAttributeMarshaller {
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").isBinary(false).build();
    private static final MarshallingInfo<String> THINGTYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingTypeName").isBinary(false).build();
    private static final MarshallingInfo<String> THINGARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingArn").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").isBinary(false).build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final ThingAttributeMarshaller INSTANCE = new ThingAttributeMarshaller();

    private ThingAttributeMarshaller() {
    }

    public static ThingAttributeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ThingAttribute thingAttribute, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)thingAttribute, (String)"thingAttribute");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)thingAttribute.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall((Object)thingAttribute.thingTypeName(), THINGTYPENAME_BINDING);
            protocolMarshaller.marshall((Object)thingAttribute.thingArn(), THINGARN_BINDING);
            protocolMarshaller.marshall(thingAttribute.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)thingAttribute.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

