/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.ThingAttribute;

public class ThingAttributeUnmarshaller
implements Unmarshaller<ThingAttribute, JsonUnmarshallerContext> {
    private static final ThingAttributeUnmarshaller INSTANCE = new ThingAttributeUnmarshaller();

    public ThingAttribute unmarshall(JsonUnmarshallerContext context) throws Exception {
        ThingAttribute.Builder thingAttributeBuilder = ThingAttribute.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("thingName", targetDepth)) {
                    context.nextToken();
                    thingAttributeBuilder.thingName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("thingTypeName", targetDepth)) {
                    context.nextToken();
                    thingAttributeBuilder.thingTypeName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("thingArn", targetDepth)) {
                    context.nextToken();
                    thingAttributeBuilder.thingArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("attributes", targetDepth)) {
                    context.nextToken();
                    thingAttributeBuilder.attributes(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    thingAttributeBuilder.version((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ThingAttribute)thingAttributeBuilder.build();
    }

    public static ThingAttributeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

