/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ThingDocument;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ThingDocumentMarshaller {
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").isBinary(false).build();
    private static final MarshallingInfo<String> THINGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingId").isBinary(false).build();
    private static final MarshallingInfo<String> THINGTYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingTypeName").isBinary(false).build();
    private static final MarshallingInfo<List> THINGGROUPNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingGroupNames").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").isBinary(false).build();
    private static final MarshallingInfo<String> SHADOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("shadow").isBinary(false).build();
    private static final ThingDocumentMarshaller INSTANCE = new ThingDocumentMarshaller();

    private ThingDocumentMarshaller() {
    }

    public static ThingDocumentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ThingDocument thingDocument, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)thingDocument, (String)"thingDocument");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)thingDocument.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall((Object)thingDocument.thingId(), THINGID_BINDING);
            protocolMarshaller.marshall((Object)thingDocument.thingTypeName(), THINGTYPENAME_BINDING);
            protocolMarshaller.marshall(thingDocument.thingGroupNames(), THINGGROUPNAMES_BINDING);
            protocolMarshaller.marshall(thingDocument.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)thingDocument.shadow(), SHADOW_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

