/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ThingGroupDocument;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ThingGroupDocumentMarshaller {
    private static final MarshallingInfo<String> THINGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> THINGGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingGroupId").isBinary(false).build();
    private static final MarshallingInfo<String> THINGGROUPDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingGroupDescription").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").isBinary(false).build();
    private static final MarshallingInfo<List> PARENTGROUPNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parentGroupNames").isBinary(false).build();
    private static final ThingGroupDocumentMarshaller INSTANCE = new ThingGroupDocumentMarshaller();

    private ThingGroupDocumentMarshaller() {
    }

    public static ThingGroupDocumentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ThingGroupDocument thingGroupDocument, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)thingGroupDocument, (String)"thingGroupDocument");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)thingGroupDocument.thingGroupName(), THINGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)thingGroupDocument.thingGroupId(), THINGGROUPID_BINDING);
            protocolMarshaller.marshall((Object)thingGroupDocument.thingGroupDescription(), THINGGROUPDESCRIPTION_BINDING);
            protocolMarshaller.marshall(thingGroupDocument.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(thingGroupDocument.parentGroupNames(), PARENTGROUPNAMES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

