/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ThingTypeMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ThingTypeMetadataMarshaller {
    private static final MarshallingInfo<Boolean> DEPRECATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deprecated").isBinary(false).build();
    private static final MarshallingInfo<Instant> DEPRECATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deprecationDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();
    private static final ThingTypeMetadataMarshaller INSTANCE = new ThingTypeMetadataMarshaller();

    private ThingTypeMetadataMarshaller() {
    }

    public static ThingTypeMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ThingTypeMetadata thingTypeMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)thingTypeMetadata, (String)"thingTypeMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)thingTypeMetadata.deprecated(), DEPRECATED_BINDING);
            protocolMarshaller.marshall((Object)thingTypeMetadata.deprecationDate(), DEPRECATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)thingTypeMetadata.creationDate(), CREATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

