/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateSecurityProfileRequestModelMarshaller {
    private static final MarshallingInfo<String> SECURITYPROFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("securityProfileName").isBinary(false).build();
    private static final MarshallingInfo<String> SECURITYPROFILEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityProfileDescription").isBinary(false).build();
    private static final MarshallingInfo<List> BEHAVIORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("behaviors").isBinary(false).build();
    private static final MarshallingInfo<Map> ALERTTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alertTargets").isBinary(false).build();
    private static final MarshallingInfo<Long> EXPECTEDVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("expectedVersion").isBinary(false).build();
    private static final UpdateSecurityProfileRequestModelMarshaller INSTANCE = new UpdateSecurityProfileRequestModelMarshaller();

    private UpdateSecurityProfileRequestModelMarshaller() {
    }

    public static UpdateSecurityProfileRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateSecurityProfileRequest updateSecurityProfileRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateSecurityProfileRequest), (String)"updateSecurityProfileRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateSecurityProfileRequest.securityProfileName(), SECURITYPROFILENAME_BINDING);
            protocolMarshaller.marshall((Object)updateSecurityProfileRequest.securityProfileDescription(), SECURITYPROFILEDESCRIPTION_BINDING);
            protocolMarshaller.marshall(updateSecurityProfileRequest.behaviors(), BEHAVIORS_BINDING);
            protocolMarshaller.marshall(updateSecurityProfileRequest.alertTargetsAsStrings(), ALERTTARGETS_BINDING);
            protocolMarshaller.marshall((Object)updateSecurityProfileRequest.expectedVersion(), EXPECTEDVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

