/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.ViolationEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ViolationEventMarshaller {
    private static final MarshallingInfo<String> VIOLATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationId").isBinary(false).build();
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").isBinary(false).build();
    private static final MarshallingInfo<String> SECURITYPROFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityProfileName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("behavior").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> METRICVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricValue").isBinary(false).build();
    private static final MarshallingInfo<String> VIOLATIONEVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationEventType").isBinary(false).build();
    private static final MarshallingInfo<Instant> VIOLATIONEVENTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("violationEventTime").isBinary(false).build();
    private static final ViolationEventMarshaller INSTANCE = new ViolationEventMarshaller();

    private ViolationEventMarshaller() {
    }

    public static ViolationEventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ViolationEvent violationEvent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)violationEvent, (String)"violationEvent");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)violationEvent.violationId(), VIOLATIONID_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.securityProfileName(), SECURITYPROFILENAME_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.behavior(), BEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.metricValue(), METRICVALUE_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.violationEventTypeAsString(), VIOLATIONEVENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)violationEvent.violationEventTime(), VIOLATIONEVENTTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

