/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListPolicyPrincipals operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPolicyPrincipalsResponse extends IotResponse implements
        ToCopyableBuilder<ListPolicyPrincipalsResponse.Builder, ListPolicyPrincipalsResponse> {
    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListPolicyPrincipalsResponse::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPolicyPrincipalsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPALS_FIELD,
            NEXT_MARKER_FIELD));

    private final List<String> principals;

    private final String nextMarker;

    private ListPolicyPrincipalsResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The descriptions of the principals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The descriptions of the principals.
     */
    public List<String> principals() {
        return principals;
    }

    /**
     * <p>
     * The marker for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The marker for the next set of results, or null if there are no additional results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principals());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyPrincipalsResponse)) {
            return false;
        }
        ListPolicyPrincipalsResponse other = (ListPolicyPrincipalsResponse) obj;
        return Objects.equals(principals(), other.principals()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("ListPolicyPrincipalsResponse").add("Principals", principals()).add("NextMarker", nextMarker())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "nextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyPrincipalsResponse, T> g) {
        return obj -> g.apply((ListPolicyPrincipalsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPolicyPrincipalsResponse> {
        /**
         * <p>
         * The descriptions of the principals.
         * </p>
         * 
         * @param principals
         *        The descriptions of the principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<String> principals);

        /**
         * <p>
         * The descriptions of the principals.
         * </p>
         * 
         * @param principals
         *        The descriptions of the principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(String... principals);

        /**
         * <p>
         * The marker for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextMarker
         *        The marker for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<String> principals = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyPrincipalsResponse model) {
            super(model);
            principals(model.principals);
            nextMarker(model.nextMarker);
        }

        public final Collection<String> getPrincipals() {
            return principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListPolicyPrincipalsResponse build() {
            return new ListPolicyPrincipalsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
