/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachPrincipalPolicyRequest
extends IotRequest
implements ToCopyableBuilder<Builder, AttachPrincipalPolicyRequest> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AttachPrincipalPolicyRequest.getter(AttachPrincipalPolicyRequest::policyName)).setter(AttachPrincipalPolicyRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyName").build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AttachPrincipalPolicyRequest.getter(AttachPrincipalPolicyRequest::principal)).setter(AttachPrincipalPolicyRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-iot-principal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, PRINCIPAL_FIELD));
    private final String policyName;
    private final String principal;

    private AttachPrincipalPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.principal = builder.principal;
    }

    public String policyName() {
        return this.policyName;
    }

    public String principal() {
        return this.principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachPrincipalPolicyRequest)) {
            return false;
        }
        AttachPrincipalPolicyRequest other = (AttachPrincipalPolicyRequest)((Object)obj);
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.principal(), other.principal());
    }

    public String toString() {
        return ToString.builder((String)"AttachPrincipalPolicyRequest").add("PolicyName", (Object)this.policyName()).add("Principal", (Object)this.principal()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachPrincipalPolicyRequest, T> g) {
        return obj -> g.apply((AttachPrincipalPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String policyName;
        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachPrincipalPolicyRequest model) {
            super(model);
            this.policyName(model.policyName);
            this.principal(model.principal);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachPrincipalPolicyRequest build() {
            return new AttachPrincipalPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachPrincipalPolicyRequest> {
        public Builder policyName(String var1);

        public Builder principal(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

