/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.AttachPrincipalPolicyRequest;
import software.amazon.awssdk.services.iot.model.AttachPrincipalPolicyResponse;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.CertificateConflictException;
import software.amazon.awssdk.services.iot.model.CertificateStateException;
import software.amazon.awssdk.services.iot.model.CertificateValidationException;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateThingRequest;
import software.amazon.awssdk.services.iot.model.CreateThingResponse;
import software.amazon.awssdk.services.iot.model.CreateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.CreateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteCACertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCACertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteConflictException;
import software.amazon.awssdk.services.iot.model.DeletePolicyRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DescribeCACertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCACertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.iot.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DetachPrincipalPolicyRequest;
import software.amazon.awssdk.services.iot.model.DetachPrincipalPolicyResponse;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.InternalException;
import software.amazon.awssdk.services.iot.model.InternalFailureException;
import software.amazon.awssdk.services.iot.model.InvalidRequestException;
import software.amazon.awssdk.services.iot.model.LimitExceededException;
import software.amazon.awssdk.services.iot.model.ListCACertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCACertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCARequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCAResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListPolicyPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListPolicyPrincipalsResponse;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListPrincipalPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse;
import software.amazon.awssdk.services.iot.model.ListThingTypesRequest;
import software.amazon.awssdk.services.iot.model.ListThingTypesResponse;
import software.amazon.awssdk.services.iot.model.ListThingsRequest;
import software.amazon.awssdk.services.iot.model.ListThingsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRulesRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRulesResponse;
import software.amazon.awssdk.services.iot.model.MalformedPolicyException;
import software.amazon.awssdk.services.iot.model.RegisterCACertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCACertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegistrationCodeValidationException;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iot.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iot.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.SqlParseException;
import software.amazon.awssdk.services.iot.model.ThrottlingException;
import software.amazon.awssdk.services.iot.model.TransferAlreadyCompletedException;
import software.amazon.awssdk.services.iot.model.TransferCertificateRequest;
import software.amazon.awssdk.services.iot.model.TransferCertificateResponse;
import software.amazon.awssdk.services.iot.model.TransferConflictException;
import software.amazon.awssdk.services.iot.model.UnauthorizedException;
import software.amazon.awssdk.services.iot.model.UpdateCACertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCACertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingResponse;
import software.amazon.awssdk.services.iot.model.VersionConflictException;
import software.amazon.awssdk.services.iot.model.VersionsLimitExceededException;
import software.amazon.awssdk.services.iot.transform.AcceptCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AcceptCertificateTransferResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.AttachPrincipalPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachPrincipalPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.AttachThingPrincipalRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachThingPrincipalResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.CancelCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelCertificateTransferResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.CreateCertificateFromCsrRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateCertificateFromCsrResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.CreateKeysAndCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateKeysAndCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePolicyResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePolicyVersionResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingTypeResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.CreateTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateTopicRuleResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCACertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCACertificateResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePolicyResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePolicyVersionResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteRegistrationCodeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteRegistrationCodeResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingTypeResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteTopicRuleResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DeprecateThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeprecateThingTypeResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCACertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCACertificateResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingTypeResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DetachPrincipalPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachPrincipalPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DetachThingPrincipalRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachThingPrincipalResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.DisableTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DisableTopicRuleResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.EnableTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.EnableTopicRuleResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.GetLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetLoggingOptionsResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.GetPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPolicyVersionResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.GetRegistrationCodeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetRegistrationCodeResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.GetTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetTopicRuleResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListCACertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCACertificatesResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificatesByCARequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificatesByCAResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificatesResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListOutgoingCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListOutgoingCertificatesResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPoliciesResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListPolicyPrincipalsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPolicyPrincipalsResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPolicyVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListPrincipalPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPrincipalPoliciesResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListPrincipalThingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPrincipalThingsResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingPrincipalsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingPrincipalsResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingTypesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingTypesResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ListTopicRulesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTopicRulesResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCACertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCACertificateResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.RejectCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RejectCertificateTransferResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.ReplaceTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ReplaceTopicRuleResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.SetDefaultPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetDefaultPolicyVersionResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.SetLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetLoggingOptionsResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.TransferCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TransferCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCACertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCACertificateResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingResponseUnmarshaller;

/**
 * Internal implementation of {@link IoTAsyncClient}.
 *
 * @see IoTAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIoTAsyncClient implements IoTAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultIoTAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams)
                .withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * 
     * @param acceptCertificateTransferRequest
     *        The input for the AcceptCertificateTransfer operation.
     * @return A Java Future containing the result of the AcceptCertificateTransfer operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.AcceptCertificateTransfer
     */
    @Override
    public CompletableFuture<AcceptCertificateTransferResponse> acceptCertificateTransfer(
            AcceptCertificateTransferRequest acceptCertificateTransferRequest) {

        HttpResponseHandler<AcceptCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new AcceptCertificateTransferResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<AcceptCertificateTransferRequest, AcceptCertificateTransferResponse>()
                        .withMarshaller(new AcceptCertificateTransferRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(acceptCertificateTransferRequest));
    }

    /**
     * <p>
     * Attaches the specified policy to the specified principal (certificate or other credential).
     * </p>
     * 
     * @param attachPrincipalPolicyRequest
     *        The input for the AttachPrincipalPolicy operation.
     * @return A Java Future containing the result of the AttachPrincipalPolicy operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException The number of attached entities exceeds the limit.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.AttachPrincipalPolicy
     */
    @Override
    public CompletableFuture<AttachPrincipalPolicyResponse> attachPrincipalPolicy(
            AttachPrincipalPolicyRequest attachPrincipalPolicyRequest) {

        HttpResponseHandler<AttachPrincipalPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new AttachPrincipalPolicyResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AttachPrincipalPolicyRequest, AttachPrincipalPolicyResponse>()
                .withMarshaller(new AttachPrincipalPolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(attachPrincipalPolicyRequest));
    }

    /**
     * <p>
     * Attaches the specified principal to the specified thing.
     * </p>
     * 
     * @param attachThingPrincipalRequest
     *        The input for the AttachThingPrincipal operation.
     * @return A Java Future containing the result of the AttachThingPrincipal operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.AttachThingPrincipal
     */
    @Override
    public CompletableFuture<AttachThingPrincipalResponse> attachThingPrincipal(
            AttachThingPrincipalRequest attachThingPrincipalRequest) {

        HttpResponseHandler<AttachThingPrincipalResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new AttachThingPrincipalResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AttachThingPrincipalRequest, AttachThingPrincipalResponse>()
                .withMarshaller(new AttachThingPrincipalRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(attachThingPrincipalRequest));
    }

    /**
     * <p>
     * Cancels a pending transfer for the specified certificate.
     * </p>
     * <p>
     * <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations
     * can use <a>RejectCertificateTransfer</a> instead.) After transfer, AWS IoT returns the certificate to the source
     * account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be
     * cancelled.
     * </p>
     * <p>
     * After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to
     * INACTIVE.
     * </p>
     * 
     * @param cancelCertificateTransferRequest
     *        The input for the CancelCertificateTransfer operation.
     * @return A Java Future containing the result of the CancelCertificateTransfer operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.CancelCertificateTransfer
     */
    @Override
    public CompletableFuture<CancelCertificateTransferResponse> cancelCertificateTransfer(
            CancelCertificateTransferRequest cancelCertificateTransferRequest) {

        HttpResponseHandler<CancelCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CancelCertificateTransferResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CancelCertificateTransferRequest, CancelCertificateTransferResponse>()
                        .withMarshaller(new CancelCertificateTransferRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(cancelCertificateTransferRequest));
    }

    /**
     * <p>
     * Creates an X.509 certificate using the specified certificate signing request.
     * </p>
     * <p>
     * <b>Note:</b> The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or
     * an ECC key from NIST P-256 or NIST P-384 curves.
     * </p>
     * <p>
     * <b>Note:</b> Reusing the same certificate signing request (CSR) results in a distinct certificate.
     * </p>
     * <p>
     * You can create multiple certificates in a batch by creating a directory, copying multiple .csr files into that
     * directory, and then specifying that directory on the command line. The following commands show how to create a
     * batch of certificates given a batch of CSRs.
     * </p>
     * <p>
     * Assuming a set of CSRs are located inside of the directory my-csr-directory:
     * </p>
     * <p>
     * On Linux and OS X, the command is:
     * </p>
     * <p>
     * &#36; ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/{}
     * </p>
     * <p>
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the aws iot
     * create-certificate-from-csr AWS CLI command to create a certificate for the corresponding CSR.
     * </p>
     * <p>
     * The aws iot create-certificate-from-csr part of the command can also be run in parallel to speed up the
     * certificate creation process:
     * </p>
     * <p>
     * &#36; ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/{}
     * </p>
     * <p>
     * On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * &gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/&#36;_}
     * </p>
     * <p>
     * On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * &gt; forfiles /p my-csr-directory /c
     * "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path"
     * </p>
     * 
     * @param createCertificateFromCsrRequest
     *        The input for the CreateCertificateFromCsr operation.
     * @return A Java Future containing the result of the CreateCertificateFromCsr operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.CreateCertificateFromCsr
     */
    @Override
    public CompletableFuture<CreateCertificateFromCsrResponse> createCertificateFromCsr(
            CreateCertificateFromCsrRequest createCertificateFromCsrRequest) {

        HttpResponseHandler<CreateCertificateFromCsrResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateCertificateFromCsrResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CreateCertificateFromCsrRequest, CreateCertificateFromCsrResponse>()
                        .withMarshaller(new CreateCertificateFromCsrRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createCertificateFromCsrRequest));
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key.
     * </p>
     * <p>
     * <b>Note</b> This is the only time AWS IoT issues the private key for this certificate, so it is important to keep
     * it in a secure location.
     * </p>
     * 
     * @param createKeysAndCertificateRequest
     *        The input for the CreateKeysAndCertificate operation.
     * @return A Java Future containing the result of the CreateKeysAndCertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.CreateKeysAndCertificate
     */
    @Override
    public CompletableFuture<CreateKeysAndCertificateResponse> createKeysAndCertificate() {
        return createKeysAndCertificate(CreateKeysAndCertificateRequest.builder().build());
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key.
     * </p>
     * <p>
     * <b>Note</b> This is the only time AWS IoT issues the private key for this certificate, so it is important to keep
     * it in a secure location.
     * </p>
     * 
     * @param createKeysAndCertificateRequest
     *        The input for the CreateKeysAndCertificate operation.
     * @return A Java Future containing the result of the CreateKeysAndCertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.CreateKeysAndCertificate
     */
    @Override
    public CompletableFuture<CreateKeysAndCertificateResponse> createKeysAndCertificate(
            CreateKeysAndCertificateRequest createKeysAndCertificateRequest) {

        HttpResponseHandler<CreateKeysAndCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateKeysAndCertificateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CreateKeysAndCertificateRequest, CreateKeysAndCertificateResponse>()
                        .withMarshaller(new CreateKeysAndCertificateRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createKeysAndCertificateRequest));
    }

    /**
     * <p>
     * Creates an AWS IoT policy.
     * </p>
     * <p>
     * The created policy is the default version for the policy. This operation creates a policy version with a version
     * identifier of <b>1</b> and sets <b>1</b> as the policy's default version.
     * </p>
     * 
     * @param createPolicyRequest
     *        The input for the CreatePolicy operation.
     * @return A Java Future containing the result of the CreatePolicy operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>MalformedPolicyException The policy documentation is not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.CreatePolicy
     */
    @Override
    public CompletableFuture<CreatePolicyResponse> createPolicy(CreatePolicyRequest createPolicyRequest) {

        HttpResponseHandler<CreatePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreatePolicyResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreatePolicyRequest, CreatePolicyResponse>()
                .withMarshaller(new CreatePolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createPolicyRequest));
    }

    /**
     * <p>
     * Creates a new version of the specified AWS IoT policy. To update a policy, create a new policy version. A managed
     * policy can have up to five versions. If the policy has five versions, you must use <a>DeletePolicyVersion</a> to
     * delete an existing version before you create a new one.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the operative
     * version (that is, the version that is in effect for the certificates to which the policy is attached).
     * </p>
     * 
     * @param createPolicyVersionRequest
     *        The input for the CreatePolicyVersion operation.
     * @return A Java Future containing the result of the CreatePolicyVersion operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>MalformedPolicyException The policy documentation is not valid.</li>
     *         <li>VersionsLimitExceededException The number of policy versions exceeds the limit.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.CreatePolicyVersion
     */
    @Override
    public CompletableFuture<CreatePolicyVersionResponse> createPolicyVersion(
            CreatePolicyVersionRequest createPolicyVersionRequest) {

        HttpResponseHandler<CreatePolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreatePolicyVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreatePolicyVersionRequest, CreatePolicyVersionResponse>()
                .withMarshaller(new CreatePolicyVersionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createPolicyVersionRequest));
    }

    /**
     * <p>
     * Creates a thing record in the thing registry.
     * </p>
     * 
     * @param createThingRequest
     *        The input for the CreateThing operation.
     * @return A Java Future containing the result of the CreateThing operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.CreateThing
     */
    @Override
    public CompletableFuture<CreateThingResponse> createThing(CreateThingRequest createThingRequest) {

        HttpResponseHandler<CreateThingResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateThingResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateThingRequest, CreateThingResponse>()
                .withMarshaller(new CreateThingRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createThingRequest));
    }

    /**
     * <p>
     * Creates a new thing type.
     * </p>
     * 
     * @param createThingTypeRequest
     *        The input for the CreateThingType operation.
     * @return A Java Future containing the result of the CreateThingType operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.CreateThingType
     */
    @Override
    public CompletableFuture<CreateThingTypeResponse> createThingType(CreateThingTypeRequest createThingTypeRequest) {

        HttpResponseHandler<CreateThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateThingTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateThingTypeRequest, CreateThingTypeResponse>()
                .withMarshaller(new CreateThingTypeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createThingTypeRequest));
    }

    /**
     * <p>
     * Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will
     * be able to access data processed by the rule.
     * </p>
     * 
     * @param createTopicRuleRequest
     *        The input for the CreateTopicRule operation.
     * @return A Java Future containing the result of the CreateTopicRule operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SqlParseException The Rule-SQL expression can't be parsed correctly.</li>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.CreateTopicRule
     */
    @Override
    public CompletableFuture<CreateTopicRuleResponse> createTopicRule(CreateTopicRuleRequest createTopicRuleRequest) {

        HttpResponseHandler<CreateTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateTopicRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateTopicRuleRequest, CreateTopicRuleResponse>()
                .withMarshaller(new CreateTopicRuleRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createTopicRuleRequest));
    }

    /**
     * <p>
     * Deletes a registered CA certificate.
     * </p>
     * 
     * @param deleteCACertificateRequest
     *        Input for the DeleteCACertificate operation.
     * @return A Java Future containing the result of the DeleteCACertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DeleteCACertificate
     */
    @Override
    public CompletableFuture<DeleteCACertificateResponse> deleteCACertificate(
            DeleteCACertificateRequest deleteCACertificateRequest) {

        HttpResponseHandler<DeleteCACertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteCACertificateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteCACertificateRequest, DeleteCACertificateResponse>()
                .withMarshaller(new DeleteCACertificateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteCACertificateRequest));
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <p>
     * A certificate cannot be deleted if it has a policy attached to it or if its status is set to ACTIVE. To delete a
     * certificate, first use the <a>DetachPrincipalPolicy</a> API to detach all policies. Next, use the
     * <a>UpdateCertificate</a> API to set the certificate to the INACTIVE status.
     * </p>
     * 
     * @param deleteCertificateRequest
     *        The input for the DeleteCertificate operation.
     * @return A Java Future containing the result of the DeleteCertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DeleteCertificate
     */
    @Override
    public CompletableFuture<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) {

        HttpResponseHandler<DeleteCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteCertificateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteCertificateRequest, DeleteCertificateResponse>()
                .withMarshaller(new DeleteCertificateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteCertificateRequest));
    }

    /**
     * <p>
     * Deletes the specified policy.
     * </p>
     * <p>
     * A policy cannot be deleted if it has non-default versions or it is attached to any certificate.
     * </p>
     * <p>
     * To delete a policy, use the DeletePolicyVersion API to delete all non-default versions of the policy; use the
     * DetachPrincipalPolicy API to detach the policy from any certificate; and then use the DeletePolicy API to delete
     * the policy.
     * </p>
     * <p>
     * When a policy is deleted using DeletePolicy, its default version is deleted with it.
     * </p>
     * 
     * @param deletePolicyRequest
     *        The input for the DeletePolicy operation.
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DeletePolicy
     */
    @Override
    public CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {

        HttpResponseHandler<DeletePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeletePolicyResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeletePolicyRequest, DeletePolicyResponse>()
                .withMarshaller(new DeletePolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deletePolicyRequest));
    }

    /**
     * <p>
     * Deletes the specified version of the specified policy. You cannot delete the default version of a policy using
     * this API. To delete the default version of a policy, use <a>DeletePolicy</a>. To find out which version of a
     * policy is marked as the default version, use ListPolicyVersions.
     * </p>
     * 
     * @param deletePolicyVersionRequest
     *        The input for the DeletePolicyVersion operation.
     * @return A Java Future containing the result of the DeletePolicyVersion operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DeletePolicyVersion
     */
    @Override
    public CompletableFuture<DeletePolicyVersionResponse> deletePolicyVersion(
            DeletePolicyVersionRequest deletePolicyVersionRequest) {

        HttpResponseHandler<DeletePolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeletePolicyVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeletePolicyVersionRequest, DeletePolicyVersionResponse>()
                .withMarshaller(new DeletePolicyVersionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deletePolicyVersionRequest));
    }

    /**
     * <p>
     * Deletes a CA certificate registration code.
     * </p>
     * 
     * @param deleteRegistrationCodeRequest
     *        The input for the DeleteRegistrationCode operation.
     * @return A Java Future containing the result of the DeleteRegistrationCode operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DeleteRegistrationCode
     */
    @Override
    public CompletableFuture<DeleteRegistrationCodeResponse> deleteRegistrationCode() {
        return deleteRegistrationCode(DeleteRegistrationCodeRequest.builder().build());
    }

    /**
     * <p>
     * Deletes a CA certificate registration code.
     * </p>
     * 
     * @param deleteRegistrationCodeRequest
     *        The input for the DeleteRegistrationCode operation.
     * @return A Java Future containing the result of the DeleteRegistrationCode operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DeleteRegistrationCode
     */
    @Override
    public CompletableFuture<DeleteRegistrationCodeResponse> deleteRegistrationCode(
            DeleteRegistrationCodeRequest deleteRegistrationCodeRequest) {

        HttpResponseHandler<DeleteRegistrationCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteRegistrationCodeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteRegistrationCodeRequest, DeleteRegistrationCodeResponse>()
                .withMarshaller(new DeleteRegistrationCodeRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteRegistrationCodeRequest));
    }

    /**
     * <p>
     * Deletes the specified thing.
     * </p>
     * 
     * @param deleteThingRequest
     *        The input for the DeleteThing operation.
     * @return A Java Future containing the result of the DeleteThing operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>VersionConflictException An exception thrown when the version of a thing passed to a command is
     *         different than the version specified with the --version parameter.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DeleteThing
     */
    @Override
    public CompletableFuture<DeleteThingResponse> deleteThing(DeleteThingRequest deleteThingRequest) {

        HttpResponseHandler<DeleteThingResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteThingResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteThingRequest, DeleteThingResponse>()
                .withMarshaller(new DeleteThingRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteThingRequest));
    }

    /**
     * <p>
     * Deletes the specified thing type . You cannot delete a thing type if it has things associated with it. To delete
     * a thing type, first mark it as deprecated by calling <a>DeprecateThingType</a>, then remove any associated things
     * by calling <a>UpdateThing</a> to change the thing type on any associated thing, and finally use
     * <a>DeleteThingType</a> to delete the thing type.
     * </p>
     * 
     * @param deleteThingTypeRequest
     *        The input for the DeleteThingType operation.
     * @return A Java Future containing the result of the DeleteThingType operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DeleteThingType
     */
    @Override
    public CompletableFuture<DeleteThingTypeResponse> deleteThingType(DeleteThingTypeRequest deleteThingTypeRequest) {

        HttpResponseHandler<DeleteThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteThingTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteThingTypeRequest, DeleteThingTypeResponse>()
                .withMarshaller(new DeleteThingTypeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteThingTypeRequest));
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * 
     * @param deleteTopicRuleRequest
     *        The input for the DeleteTopicRule operation.
     * @return A Java Future containing the result of the DeleteTopicRule operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DeleteTopicRule
     */
    @Override
    public CompletableFuture<DeleteTopicRuleResponse> deleteTopicRule(DeleteTopicRuleRequest deleteTopicRuleRequest) {

        HttpResponseHandler<DeleteTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteTopicRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteTopicRuleRequest, DeleteTopicRuleResponse>()
                .withMarshaller(new DeleteTopicRuleRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteTopicRuleRequest));
    }

    /**
     * <p>
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * </p>
     * 
     * @param deprecateThingTypeRequest
     *        The input for the DeprecateThingType operation.
     * @return A Java Future containing the result of the DeprecateThingType operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DeprecateThingType
     */
    @Override
    public CompletableFuture<DeprecateThingTypeResponse> deprecateThingType(DeprecateThingTypeRequest deprecateThingTypeRequest) {

        HttpResponseHandler<DeprecateThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeprecateThingTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeprecateThingTypeRequest, DeprecateThingTypeResponse>()
                .withMarshaller(new DeprecateThingTypeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deprecateThingTypeRequest));
    }

    /**
     * <p>
     * Describes a registered CA certificate.
     * </p>
     * 
     * @param describeCACertificateRequest
     *        The input for the DescribeCACertificate operation.
     * @return A Java Future containing the result of the DescribeCACertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DescribeCACertificate
     */
    @Override
    public CompletableFuture<DescribeCACertificateResponse> describeCACertificate(
            DescribeCACertificateRequest describeCACertificateRequest) {

        HttpResponseHandler<DescribeCACertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeCACertificateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeCACertificateRequest, DescribeCACertificateResponse>()
                .withMarshaller(new DescribeCACertificateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeCACertificateRequest));
    }

    /**
     * <p>
     * Gets information about the specified certificate.
     * </p>
     * 
     * @param describeCertificateRequest
     *        The input for the DescribeCertificate operation.
     * @return A Java Future containing the result of the DescribeCertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DescribeCertificate
     */
    @Override
    public CompletableFuture<DescribeCertificateResponse> describeCertificate(
            DescribeCertificateRequest describeCertificateRequest) {

        HttpResponseHandler<DescribeCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeCertificateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeCertificateRequest, DescribeCertificateResponse>()
                .withMarshaller(new DescribeCertificateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeCertificateRequest));
    }

    /**
     * <p>
     * Returns a unique endpoint specific to the AWS account making the call.
     * </p>
     * 
     * @param describeEndpointRequest
     *        The input for the DescribeEndpoint operation.
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DescribeEndpoint
     */
    @Override
    public CompletableFuture<DescribeEndpointResponse> describeEndpoint() {
        return describeEndpoint(DescribeEndpointRequest.builder().build());
    }

    /**
     * <p>
     * Returns a unique endpoint specific to the AWS account making the call.
     * </p>
     * 
     * @param describeEndpointRequest
     *        The input for the DescribeEndpoint operation.
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DescribeEndpoint
     */
    @Override
    public CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {

        HttpResponseHandler<DescribeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeEndpointResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeEndpointRequest, DescribeEndpointResponse>()
                .withMarshaller(new DescribeEndpointRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeEndpointRequest));
    }

    /**
     * <p>
     * Gets information about the specified thing.
     * </p>
     * 
     * @param describeThingRequest
     *        The input for the DescribeThing operation.
     * @return A Java Future containing the result of the DescribeThing operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DescribeThing
     */
    @Override
    public CompletableFuture<DescribeThingResponse> describeThing(DescribeThingRequest describeThingRequest) {

        HttpResponseHandler<DescribeThingResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeThingResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeThingRequest, DescribeThingResponse>()
                .withMarshaller(new DescribeThingRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeThingRequest));
    }

    /**
     * <p>
     * Gets information about the specified thing type.
     * </p>
     * 
     * @param describeThingTypeRequest
     *        The input for the DescribeThingType operation.
     * @return A Java Future containing the result of the DescribeThingType operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DescribeThingType
     */
    @Override
    public CompletableFuture<DescribeThingTypeResponse> describeThingType(DescribeThingTypeRequest describeThingTypeRequest) {

        HttpResponseHandler<DescribeThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeThingTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeThingTypeRequest, DescribeThingTypeResponse>()
                .withMarshaller(new DescribeThingTypeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeThingTypeRequest));
    }

    /**
     * <p>
     * Removes the specified policy from the specified certificate.
     * </p>
     * 
     * @param detachPrincipalPolicyRequest
     *        The input for the DetachPrincipalPolicy operation.
     * @return A Java Future containing the result of the DetachPrincipalPolicy operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DetachPrincipalPolicy
     */
    @Override
    public CompletableFuture<DetachPrincipalPolicyResponse> detachPrincipalPolicy(
            DetachPrincipalPolicyRequest detachPrincipalPolicyRequest) {

        HttpResponseHandler<DetachPrincipalPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DetachPrincipalPolicyResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DetachPrincipalPolicyRequest, DetachPrincipalPolicyResponse>()
                .withMarshaller(new DetachPrincipalPolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(detachPrincipalPolicyRequest));
    }

    /**
     * <p>
     * Detaches the specified principal from the specified thing.
     * </p>
     * 
     * @param detachThingPrincipalRequest
     *        The input for the DetachThingPrincipal operation.
     * @return A Java Future containing the result of the DetachThingPrincipal operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DetachThingPrincipal
     */
    @Override
    public CompletableFuture<DetachThingPrincipalResponse> detachThingPrincipal(
            DetachThingPrincipalRequest detachThingPrincipalRequest) {

        HttpResponseHandler<DetachThingPrincipalResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DetachThingPrincipalResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DetachThingPrincipalRequest, DetachThingPrincipalResponse>()
                .withMarshaller(new DetachThingPrincipalRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(detachThingPrincipalRequest));
    }

    /**
     * <p>
     * Disables the specified rule.
     * </p>
     * 
     * @param disableTopicRuleRequest
     *        The input for the DisableTopicRuleRequest operation.
     * @return A Java Future containing the result of the DisableTopicRule operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.DisableTopicRule
     */
    @Override
    public CompletableFuture<DisableTopicRuleResponse> disableTopicRule(DisableTopicRuleRequest disableTopicRuleRequest) {

        HttpResponseHandler<DisableTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DisableTopicRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DisableTopicRuleRequest, DisableTopicRuleResponse>()
                .withMarshaller(new DisableTopicRuleRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(disableTopicRuleRequest));
    }

    /**
     * <p>
     * Enables the specified rule.
     * </p>
     * 
     * @param enableTopicRuleRequest
     *        The input for the EnableTopicRuleRequest operation.
     * @return A Java Future containing the result of the EnableTopicRule operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.EnableTopicRule
     */
    @Override
    public CompletableFuture<EnableTopicRuleResponse> enableTopicRule(EnableTopicRuleRequest enableTopicRuleRequest) {

        HttpResponseHandler<EnableTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new EnableTopicRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<EnableTopicRuleRequest, EnableTopicRuleResponse>()
                .withMarshaller(new EnableTopicRuleRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(enableTopicRuleRequest));
    }

    /**
     * <p>
     * Gets the logging options.
     * </p>
     * 
     * @param getLoggingOptionsRequest
     *        The input for the GetLoggingOptions operation.
     * @return A Java Future containing the result of the GetLoggingOptions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.GetLoggingOptions
     */
    @Override
    public CompletableFuture<GetLoggingOptionsResponse> getLoggingOptions() {
        return getLoggingOptions(GetLoggingOptionsRequest.builder().build());
    }

    /**
     * <p>
     * Gets the logging options.
     * </p>
     * 
     * @param getLoggingOptionsRequest
     *        The input for the GetLoggingOptions operation.
     * @return A Java Future containing the result of the GetLoggingOptions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.GetLoggingOptions
     */
    @Override
    public CompletableFuture<GetLoggingOptionsResponse> getLoggingOptions(GetLoggingOptionsRequest getLoggingOptionsRequest) {

        HttpResponseHandler<GetLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetLoggingOptionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetLoggingOptionsRequest, GetLoggingOptionsResponse>()
                .withMarshaller(new GetLoggingOptionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getLoggingOptionsRequest));
    }

    /**
     * <p>
     * Gets information about the specified policy with the policy document of the default version.
     * </p>
     * 
     * @param getPolicyRequest
     *        The input for the GetPolicy operation.
     * @return A Java Future containing the result of the GetPolicy operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.GetPolicy
     */
    @Override
    public CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {

        HttpResponseHandler<GetPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetPolicyResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetPolicyRequest, GetPolicyResponse>()
                .withMarshaller(new GetPolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getPolicyRequest));
    }

    /**
     * <p>
     * Gets information about the specified policy version.
     * </p>
     * 
     * @param getPolicyVersionRequest
     *        The input for the GetPolicyVersion operation.
     * @return A Java Future containing the result of the GetPolicyVersion operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.GetPolicyVersion
     */
    @Override
    public CompletableFuture<GetPolicyVersionResponse> getPolicyVersion(GetPolicyVersionRequest getPolicyVersionRequest) {

        HttpResponseHandler<GetPolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetPolicyVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetPolicyVersionRequest, GetPolicyVersionResponse>()
                .withMarshaller(new GetPolicyVersionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getPolicyVersionRequest));
    }

    /**
     * <p>
     * Gets a registration code used to register a CA certificate with AWS IoT.
     * </p>
     * 
     * @param getRegistrationCodeRequest
     *        The input to the GetRegistrationCode operation.
     * @return A Java Future containing the result of the GetRegistrationCode operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.GetRegistrationCode
     */
    @Override
    public CompletableFuture<GetRegistrationCodeResponse> getRegistrationCode() {
        return getRegistrationCode(GetRegistrationCodeRequest.builder().build());
    }

    /**
     * <p>
     * Gets a registration code used to register a CA certificate with AWS IoT.
     * </p>
     * 
     * @param getRegistrationCodeRequest
     *        The input to the GetRegistrationCode operation.
     * @return A Java Future containing the result of the GetRegistrationCode operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.GetRegistrationCode
     */
    @Override
    public CompletableFuture<GetRegistrationCodeResponse> getRegistrationCode(
            GetRegistrationCodeRequest getRegistrationCodeRequest) {

        HttpResponseHandler<GetRegistrationCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetRegistrationCodeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetRegistrationCodeRequest, GetRegistrationCodeResponse>()
                .withMarshaller(new GetRegistrationCodeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getRegistrationCodeRequest));
    }

    /**
     * <p>
     * Gets information about the specified rule.
     * </p>
     * 
     * @param getTopicRuleRequest
     *        The input for the GetTopicRule operation.
     * @return A Java Future containing the result of the GetTopicRule operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.GetTopicRule
     */
    @Override
    public CompletableFuture<GetTopicRuleResponse> getTopicRule(GetTopicRuleRequest getTopicRuleRequest) {

        HttpResponseHandler<GetTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetTopicRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetTopicRuleRequest, GetTopicRuleResponse>()
                .withMarshaller(new GetTopicRuleRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getTopicRuleRequest));
    }

    /**
     * <p>
     * Lists the CA certificates registered for your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * 
     * @param listCACertificatesRequest
     *        Input for the ListCACertificates operation.
     * @return A Java Future containing the result of the ListCACertificates operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListCACertificates
     */
    @Override
    public CompletableFuture<ListCACertificatesResponse> listCACertificates() {
        return listCACertificates(ListCACertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the CA certificates registered for your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * 
     * @param listCACertificatesRequest
     *        Input for the ListCACertificates operation.
     * @return A Java Future containing the result of the ListCACertificates operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListCACertificates
     */
    @Override
    public CompletableFuture<ListCACertificatesResponse> listCACertificates(ListCACertificatesRequest listCACertificatesRequest) {

        HttpResponseHandler<ListCACertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListCACertificatesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListCACertificatesRequest, ListCACertificatesResponse>()
                .withMarshaller(new ListCACertificatesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listCACertificatesRequest));
    }

    /**
     * <p>
     * Lists the certificates registered in your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * 
     * @param listCertificatesRequest
     *        The input for the ListCertificates operation.
     * @return A Java Future containing the result of the ListCertificates operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListCertificates
     */
    @Override
    public CompletableFuture<ListCertificatesResponse> listCertificates() {
        return listCertificates(ListCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the certificates registered in your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * 
     * @param listCertificatesRequest
     *        The input for the ListCertificates operation.
     * @return A Java Future containing the result of the ListCertificates operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListCertificates
     */
    @Override
    public CompletableFuture<ListCertificatesResponse> listCertificates(ListCertificatesRequest listCertificatesRequest) {

        HttpResponseHandler<ListCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListCertificatesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListCertificatesRequest, ListCertificatesResponse>()
                .withMarshaller(new ListCertificatesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listCertificatesRequest));
    }

    /**
     * <p>
     * List the device certificates signed by the specified CA certificate.
     * </p>
     * 
     * @param listCertificatesByCARequest
     *        The input to the ListCertificatesByCA operation.
     * @return A Java Future containing the result of the ListCertificatesByCA operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListCertificatesByCA
     */
    @Override
    public CompletableFuture<ListCertificatesByCAResponse> listCertificatesByCA(
            ListCertificatesByCARequest listCertificatesByCARequest) {

        HttpResponseHandler<ListCertificatesByCAResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListCertificatesByCAResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListCertificatesByCARequest, ListCertificatesByCAResponse>()
                .withMarshaller(new ListCertificatesByCARequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listCertificatesByCARequest));
    }

    /**
     * <p>
     * Lists certificates that are being transfered but not yet accepted.
     * </p>
     * 
     * @param listOutgoingCertificatesRequest
     *        The input to the ListOutgoingCertificates operation.
     * @return A Java Future containing the result of the ListOutgoingCertificates operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListOutgoingCertificates
     */
    @Override
    public CompletableFuture<ListOutgoingCertificatesResponse> listOutgoingCertificates() {
        return listOutgoingCertificates(ListOutgoingCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists certificates that are being transfered but not yet accepted.
     * </p>
     * 
     * @param listOutgoingCertificatesRequest
     *        The input to the ListOutgoingCertificates operation.
     * @return A Java Future containing the result of the ListOutgoingCertificates operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListOutgoingCertificates
     */
    @Override
    public CompletableFuture<ListOutgoingCertificatesResponse> listOutgoingCertificates(
            ListOutgoingCertificatesRequest listOutgoingCertificatesRequest) {

        HttpResponseHandler<ListOutgoingCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListOutgoingCertificatesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ListOutgoingCertificatesRequest, ListOutgoingCertificatesResponse>()
                        .withMarshaller(new ListOutgoingCertificatesRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listOutgoingCertificatesRequest));
    }

    /**
     * <p>
     * Lists your policies.
     * </p>
     * 
     * @param listPoliciesRequest
     *        The input for the ListPolicies operation.
     * @return A Java Future containing the result of the ListPolicies operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListPolicies
     */
    @Override
    public CompletableFuture<ListPoliciesResponse> listPolicies() {
        return listPolicies(ListPoliciesRequest.builder().build());
    }

    /**
     * <p>
     * Lists your policies.
     * </p>
     * 
     * @param listPoliciesRequest
     *        The input for the ListPolicies operation.
     * @return A Java Future containing the result of the ListPolicies operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListPolicies
     */
    @Override
    public CompletableFuture<ListPoliciesResponse> listPolicies(ListPoliciesRequest listPoliciesRequest) {

        HttpResponseHandler<ListPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListPoliciesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListPoliciesRequest, ListPoliciesResponse>()
                .withMarshaller(new ListPoliciesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listPoliciesRequest));
    }

    /**
     * <p>
     * Lists the principals associated with the specified policy.
     * </p>
     * 
     * @param listPolicyPrincipalsRequest
     *        The input for the ListPolicyPrincipals operation.
     * @return A Java Future containing the result of the ListPolicyPrincipals operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListPolicyPrincipals
     */
    @Override
    public CompletableFuture<ListPolicyPrincipalsResponse> listPolicyPrincipals(
            ListPolicyPrincipalsRequest listPolicyPrincipalsRequest) {

        HttpResponseHandler<ListPolicyPrincipalsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListPolicyPrincipalsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListPolicyPrincipalsRequest, ListPolicyPrincipalsResponse>()
                .withMarshaller(new ListPolicyPrincipalsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listPolicyPrincipalsRequest));
    }

    /**
     * <p>
     * Lists the versions of the specified policy and identifies the default version.
     * </p>
     * 
     * @param listPolicyVersionsRequest
     *        The input for the ListPolicyVersions operation.
     * @return A Java Future containing the result of the ListPolicyVersions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListPolicyVersions
     */
    @Override
    public CompletableFuture<ListPolicyVersionsResponse> listPolicyVersions(ListPolicyVersionsRequest listPolicyVersionsRequest) {

        HttpResponseHandler<ListPolicyVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListPolicyVersionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListPolicyVersionsRequest, ListPolicyVersionsResponse>()
                .withMarshaller(new ListPolicyVersionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listPolicyVersionsRequest));
    }

    /**
     * <p>
     * Lists the policies attached to the specified principal. If you use an Cognito identity, the ID must be in <a
     * href=
     * "http://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax"
     * >AmazonCognito Identity format</a>.
     * </p>
     * 
     * @param listPrincipalPoliciesRequest
     *        The input for the ListPrincipalPolicies operation.
     * @return A Java Future containing the result of the ListPrincipalPolicies operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListPrincipalPolicies
     */
    @Override
    public CompletableFuture<ListPrincipalPoliciesResponse> listPrincipalPolicies(
            ListPrincipalPoliciesRequest listPrincipalPoliciesRequest) {

        HttpResponseHandler<ListPrincipalPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListPrincipalPoliciesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListPrincipalPoliciesRequest, ListPrincipalPoliciesResponse>()
                .withMarshaller(new ListPrincipalPoliciesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listPrincipalPoliciesRequest));
    }

    /**
     * <p>
     * Lists the things associated with the specified principal.
     * </p>
     * 
     * @param listPrincipalThingsRequest
     *        The input for the ListPrincipalThings operation.
     * @return A Java Future containing the result of the ListPrincipalThings operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListPrincipalThings
     */
    @Override
    public CompletableFuture<ListPrincipalThingsResponse> listPrincipalThings(
            ListPrincipalThingsRequest listPrincipalThingsRequest) {

        HttpResponseHandler<ListPrincipalThingsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListPrincipalThingsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListPrincipalThingsRequest, ListPrincipalThingsResponse>()
                .withMarshaller(new ListPrincipalThingsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listPrincipalThingsRequest));
    }

    /**
     * <p>
     * Lists the principals associated with the specified thing.
     * </p>
     * 
     * @param listThingPrincipalsRequest
     *        The input for the ListThingPrincipal operation.
     * @return A Java Future containing the result of the ListThingPrincipals operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListThingPrincipals
     */
    @Override
    public CompletableFuture<ListThingPrincipalsResponse> listThingPrincipals(
            ListThingPrincipalsRequest listThingPrincipalsRequest) {

        HttpResponseHandler<ListThingPrincipalsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListThingPrincipalsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListThingPrincipalsRequest, ListThingPrincipalsResponse>()
                .withMarshaller(new ListThingPrincipalsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listThingPrincipalsRequest));
    }

    /**
     * <p>
     * Lists the existing thing types.
     * </p>
     * 
     * @param listThingTypesRequest
     *        The input for the ListThingTypes operation.
     * @return A Java Future containing the result of the ListThingTypes operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListThingTypes
     */
    @Override
    public CompletableFuture<ListThingTypesResponse> listThingTypes() {
        return listThingTypes(ListThingTypesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the existing thing types.
     * </p>
     * 
     * @param listThingTypesRequest
     *        The input for the ListThingTypes operation.
     * @return A Java Future containing the result of the ListThingTypes operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListThingTypes
     */
    @Override
    public CompletableFuture<ListThingTypesResponse> listThingTypes(ListThingTypesRequest listThingTypesRequest) {

        HttpResponseHandler<ListThingTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListThingTypesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListThingTypesRequest, ListThingTypesResponse>()
                .withMarshaller(new ListThingTypesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listThingTypesRequest));
    }

    /**
     * <p>
     * Lists your things. Use the <b>attributeName</b> and <b>attributeValue</b> parameters to filter your things. For
     * example, calling <code>ListThings</code> with attributeName=Color and attributeValue=Red retrieves all things in
     * the registry that contain an attribute <b>Color</b> with the value <b>Red</b>.
     * </p>
     * 
     * @param listThingsRequest
     *        The input for the ListThings operation.
     * @return A Java Future containing the result of the ListThings operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListThings
     */
    @Override
    public CompletableFuture<ListThingsResponse> listThings() {
        return listThings(ListThingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists your things. Use the <b>attributeName</b> and <b>attributeValue</b> parameters to filter your things. For
     * example, calling <code>ListThings</code> with attributeName=Color and attributeValue=Red retrieves all things in
     * the registry that contain an attribute <b>Color</b> with the value <b>Red</b>.
     * </p>
     * 
     * @param listThingsRequest
     *        The input for the ListThings operation.
     * @return A Java Future containing the result of the ListThings operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListThings
     */
    @Override
    public CompletableFuture<ListThingsResponse> listThings(ListThingsRequest listThingsRequest) {

        HttpResponseHandler<ListThingsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListThingsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListThingsRequest, ListThingsResponse>()
                .withMarshaller(new ListThingsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listThingsRequest));
    }

    /**
     * <p>
     * Lists the rules for the specific topic.
     * </p>
     * 
     * @param listTopicRulesRequest
     *        The input for the ListTopicRules operation.
     * @return A Java Future containing the result of the ListTopicRules operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListTopicRules
     */
    @Override
    public CompletableFuture<ListTopicRulesResponse> listTopicRules() {
        return listTopicRules(ListTopicRulesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the rules for the specific topic.
     * </p>
     * 
     * @param listTopicRulesRequest
     *        The input for the ListTopicRules operation.
     * @return A Java Future containing the result of the ListTopicRules operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ListTopicRules
     */
    @Override
    public CompletableFuture<ListTopicRulesResponse> listTopicRules(ListTopicRulesRequest listTopicRulesRequest) {

        HttpResponseHandler<ListTopicRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListTopicRulesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListTopicRulesRequest, ListTopicRulesResponse>()
                .withMarshaller(new ListTopicRulesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTopicRulesRequest));
    }

    /**
     * <p>
     * Registers a CA certificate with AWS IoT. This CA certificate can then be used to sign device certificates, which
     * can be then registered with AWS IoT. You can register up to 10 CA certificates per AWS account that have the same
     * subject field. This enables you to have up to 10 certificate authorities sign your device certificates. If you
     * have more than one CA certificate registered, make sure you pass the CA certificate when you register your device
     * certificates with the RegisterCertificate API.
     * </p>
     * 
     * @param registerCACertificateRequest
     *        The input to the RegisterCACertificate operation.
     * @return A Java Future containing the result of the RegisterCACertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>RegistrationCodeValidationException The registration code is invalid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>LimitExceededException The number of attached entities exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.RegisterCACertificate
     */
    @Override
    public CompletableFuture<RegisterCACertificateResponse> registerCACertificate(
            RegisterCACertificateRequest registerCACertificateRequest) {

        HttpResponseHandler<RegisterCACertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RegisterCACertificateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RegisterCACertificateRequest, RegisterCACertificateResponse>()
                .withMarshaller(new RegisterCACertificateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(registerCACertificateRequest));
    }

    /**
     * <p>
     * Registers a device certificate with AWS IoT. If you have more than one CA certificate that has the same subject
     * field, you must specify the CA certificate that was used to sign the device certificate being registered.
     * </p>
     * 
     * @param registerCertificateRequest
     *        The input to the RegisterCertificate operation.
     * @return A Java Future containing the result of the RegisterCertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>CertificateConflictException Unable to verify the CA certificate used to sign the device certificate
     *         you are attempting to register. This is happens when you have registered more than one CA certificate
     *         that has the same subject field and public key.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.RegisterCertificate
     */
    @Override
    public CompletableFuture<RegisterCertificateResponse> registerCertificate(
            RegisterCertificateRequest registerCertificateRequest) {

        HttpResponseHandler<RegisterCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RegisterCertificateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RegisterCertificateRequest, RegisterCertificateResponse>()
                .withMarshaller(new RegisterCertificateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(registerCertificateRequest));
    }

    /**
     * <p>
     * Rejects a pending certificate transfer. After AWS IoT rejects a certificate transfer, the certificate status
     * changes from <b>PENDING_TRANSFER</b> to <b>INACTIVE</b>.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * <p>
     * This operation can only be called by the transfer destination. After it is called, the certificate will be
     * returned to the source's account in the INACTIVE state.
     * </p>
     * 
     * @param rejectCertificateTransferRequest
     *        The input for the RejectCertificateTransfer operation.
     * @return A Java Future containing the result of the RejectCertificateTransfer operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.RejectCertificateTransfer
     */
    @Override
    public CompletableFuture<RejectCertificateTransferResponse> rejectCertificateTransfer(
            RejectCertificateTransferRequest rejectCertificateTransferRequest) {

        HttpResponseHandler<RejectCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RejectCertificateTransferResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RejectCertificateTransferRequest, RejectCertificateTransferResponse>()
                        .withMarshaller(new RejectCertificateTransferRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(rejectCertificateTransferRequest));
    }

    /**
     * <p>
     * Replaces the specified rule. You must specify all parameters for the new rule. Creating rules is an
     * administrator-level action. Any user who has permission to create rules will be able to access data processed by
     * the rule.
     * </p>
     * 
     * @param replaceTopicRuleRequest
     *        The input for the ReplaceTopicRule operation.
     * @return A Java Future containing the result of the ReplaceTopicRule operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SqlParseException The Rule-SQL expression can't be parsed correctly.</li>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.ReplaceTopicRule
     */
    @Override
    public CompletableFuture<ReplaceTopicRuleResponse> replaceTopicRule(ReplaceTopicRuleRequest replaceTopicRuleRequest) {

        HttpResponseHandler<ReplaceTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ReplaceTopicRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ReplaceTopicRuleRequest, ReplaceTopicRuleResponse>()
                .withMarshaller(new ReplaceTopicRuleRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(replaceTopicRuleRequest));
    }

    /**
     * <p>
     * Sets the specified version of the specified policy as the policy's default (operative) version. This action
     * affects all certificates to which the policy is attached. To list the principals the policy is attached to, use
     * the ListPrincipalPolicy API.
     * </p>
     * 
     * @param setDefaultPolicyVersionRequest
     *        The input for the SetDefaultPolicyVersion operation.
     * @return A Java Future containing the result of the SetDefaultPolicyVersion operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.SetDefaultPolicyVersion
     */
    @Override
    public CompletableFuture<SetDefaultPolicyVersionResponse> setDefaultPolicyVersion(
            SetDefaultPolicyVersionRequest setDefaultPolicyVersionRequest) {

        HttpResponseHandler<SetDefaultPolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new SetDefaultPolicyVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SetDefaultPolicyVersionRequest, SetDefaultPolicyVersionResponse>()
                .withMarshaller(new SetDefaultPolicyVersionRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(setDefaultPolicyVersionRequest));
    }

    /**
     * <p>
     * Sets the logging options.
     * </p>
     * 
     * @param setLoggingOptionsRequest
     *        The input for the SetLoggingOptions operation.
     * @return A Java Future containing the result of the SetLoggingOptions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.SetLoggingOptions
     */
    @Override
    public CompletableFuture<SetLoggingOptionsResponse> setLoggingOptions(SetLoggingOptionsRequest setLoggingOptionsRequest) {

        HttpResponseHandler<SetLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new SetLoggingOptionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SetLoggingOptionsRequest, SetLoggingOptionsResponse>()
                .withMarshaller(new SetLoggingOptionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(setLoggingOptionsRequest));
    }

    /**
     * <p>
     * Transfers the specified certificate to the specified AWS account.
     * </p>
     * <p>
     * You can cancel the transfer until it is acknowledged by the recipient.
     * </p>
     * <p>
     * No notification is sent to the transfer destination's account. It is up to the caller to notify the transfer
     * target.
     * </p>
     * <p>
     * The certificate being transferred must not be in the ACTIVE state. You can use the UpdateCertificate API to
     * deactivate it.
     * </p>
     * <p>
     * The certificate must not have any policies attached to it. You can use the DetachPrincipalPolicy API to detach
     * them.
     * </p>
     * 
     * @param transferCertificateRequest
     *        The input for the TransferCertificate operation.
     * @return A Java Future containing the result of the TransferCertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>TransferConflictException You can't transfer the certificate because authorization policies are still
     *         attached.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.TransferCertificate
     */
    @Override
    public CompletableFuture<TransferCertificateResponse> transferCertificate(
            TransferCertificateRequest transferCertificateRequest) {

        HttpResponseHandler<TransferCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new TransferCertificateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<TransferCertificateRequest, TransferCertificateResponse>()
                .withMarshaller(new TransferCertificateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(transferCertificateRequest));
    }

    /**
     * <p>
     * Updates a registered CA certificate.
     * </p>
     * 
     * @param updateCACertificateRequest
     *        The input to the UpdateCACertificate operation.
     * @return A Java Future containing the result of the UpdateCACertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.UpdateCACertificate
     */
    @Override
    public CompletableFuture<UpdateCACertificateResponse> updateCACertificate(
            UpdateCACertificateRequest updateCACertificateRequest) {

        HttpResponseHandler<UpdateCACertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateCACertificateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateCACertificateRequest, UpdateCACertificateResponse>()
                .withMarshaller(new UpdateCACertificateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateCACertificateRequest));
    }

    /**
     * <p>
     * Updates the status of the specified certificate. This operation is idempotent.
     * </p>
     * <p>
     * Moving a certificate from the ACTIVE state (including REVOKED) will not disconnect currently connected devices,
     * but these devices will be unable to reconnect.
     * </p>
     * <p>
     * The ACTIVE state is required to authenticate devices connecting to AWS IoT using a certificate.
     * </p>
     * 
     * @param updateCertificateRequest
     *        The input for the UpdateCertificate operation.
     * @return A Java Future containing the result of the UpdateCertificate operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.UpdateCertificate
     */
    @Override
    public CompletableFuture<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest updateCertificateRequest) {

        HttpResponseHandler<UpdateCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateCertificateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateCertificateRequest, UpdateCertificateResponse>()
                .withMarshaller(new UpdateCertificateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateCertificateRequest));
    }

    /**
     * <p>
     * Updates the data for a thing.
     * </p>
     * 
     * @param updateThingRequest
     *        The input for the UpdateThing operation.
     * @return A Java Future containing the result of the UpdateThing operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of a thing passed to a command is
     *         different than the version specified with the --version parameter.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>IoTException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this</li >
     *         <ul>
     * @sample IoTAsyncClient.UpdateThing
     */
    @Override
    public CompletableFuture<UpdateThingResponse> updateThing(UpdateThingRequest updateThingRequest) {

        HttpResponseHandler<UpdateThingResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateThingResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateThingRequest, UpdateThingResponse>()
                .withMarshaller(new UpdateThingRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateThingRequest));
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }

    private software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(
                new JsonClientMetadata()
                        .withProtocolVersion("1.1")
                        .withSupportsCbor(false)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(software.amazon.awssdk.services.iot.model.IoTException.class)
                        .withContentTypeOverride("")
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(
                                        InternalFailureException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("DeleteConflictException").withModeledClass(
                                        DeleteConflictException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(
                                        InvalidRequestException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("CertificateConflictException").withModeledClass(
                                        CertificateConflictException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("RegistrationCodeValidationException")
                                        .withModeledClass(RegistrationCodeValidationException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(
                                        ThrottlingException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withModeledClass(
                                        UnauthorizedException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(
                                        LimitExceededException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("CertificateStateException").withModeledClass(
                                        CertificateStateException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("TransferAlreadyCompletedException").withModeledClass(
                                        TransferAlreadyCompletedException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("VersionConflictException").withModeledClass(
                                        VersionConflictException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(
                                        ResourceNotFoundException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("SqlParseException").withModeledClass(
                                        SqlParseException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("MalformedPolicyException").withModeledClass(
                                        MalformedPolicyException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(
                                        ServiceUnavailableException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("CertificateValidationException").withModeledClass(
                                        CertificateValidationException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(
                                        ResourceAlreadyExistsException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InternalException").withModeledClass(
                                        InternalException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("VersionsLimitExceededException").withModeledClass(
                                        VersionsLimitExceededException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("TransferConflictException").withModeledClass(
                                        TransferConflictException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
