/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the AttachThingPrincipal operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachThingPrincipalRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AttachThingPrincipalRequest.Builder, AttachThingPrincipalRequest> {
    private final String thingName;

    private final String principal;

    private AttachThingPrincipalRequest(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.principal = builder.principal;
    }

    /**
     * <p>
     * The name of the thing.
     * </p>
     * 
     * @return The name of the thing.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The principal, such as a certificate or other credential.
     * </p>
     * 
     * @return The principal, such as a certificate or other credential.
     */
    public String principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((thingName() == null) ? 0 : thingName().hashCode());
        hashCode = 31 * hashCode + ((principal() == null) ? 0 : principal().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachThingPrincipalRequest)) {
            return false;
        }
        AttachThingPrincipalRequest other = (AttachThingPrincipalRequest) obj;
        if (other.thingName() == null ^ this.thingName() == null) {
            return false;
        }
        if (other.thingName() != null && !other.thingName().equals(this.thingName())) {
            return false;
        }
        if (other.principal() == null ^ this.principal() == null) {
            return false;
        }
        if (other.principal() != null && !other.principal().equals(this.principal())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (thingName() != null) {
            sb.append("ThingName: ").append(thingName()).append(",");
        }
        if (principal() != null) {
            sb.append("Principal: ").append(principal()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AttachThingPrincipalRequest> {
        /**
         * <p>
         * The name of the thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The principal, such as a certificate or other credential.
         * </p>
         * 
         * @param principal
         *        The principal, such as a certificate or other credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);
    }

    private static final class BuilderImpl implements Builder {
        private String thingName;

        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachThingPrincipalRequest model) {
            setThingName(model.thingName);
            setPrincipal(model.principal);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public AttachThingPrincipalRequest build() {
            return new AttachThingPrincipalRequest(this);
        }
    }
}
