/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the DeleteThing operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteThingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteThingRequest.Builder, DeleteThingRequest> {
    private final String thingName;

    private final Long expectedVersion;

    private DeleteThingRequest(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.expectedVersion = builder.expectedVersion;
    }

    /**
     * <p>
     * The name of the thing to delete.
     * </p>
     * 
     * @return The name of the thing to delete.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The expected version of the thing record in the registry. If the version of the record in the registry does not
     * match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a
     * <code>VersionConflictException</code>.
     * </p>
     * 
     * @return The expected version of the thing record in the registry. If the version of the record in the registry
     *         does not match the expected version specified in the request, the <code>DeleteThing</code> request is
     *         rejected with a <code>VersionConflictException</code>.
     */
    public Long expectedVersion() {
        return expectedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((thingName() == null) ? 0 : thingName().hashCode());
        hashCode = 31 * hashCode + ((expectedVersion() == null) ? 0 : expectedVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteThingRequest)) {
            return false;
        }
        DeleteThingRequest other = (DeleteThingRequest) obj;
        if (other.thingName() == null ^ this.thingName() == null) {
            return false;
        }
        if (other.thingName() != null && !other.thingName().equals(this.thingName())) {
            return false;
        }
        if (other.expectedVersion() == null ^ this.expectedVersion() == null) {
            return false;
        }
        if (other.expectedVersion() != null && !other.expectedVersion().equals(this.expectedVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (thingName() != null) {
            sb.append("ThingName: ").append(thingName()).append(",");
        }
        if (expectedVersion() != null) {
            sb.append("ExpectedVersion: ").append(expectedVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteThingRequest> {
        /**
         * <p>
         * The name of the thing to delete.
         * </p>
         * 
         * @param thingName
         *        The name of the thing to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The expected version of the thing record in the registry. If the version of the record in the registry does
         * not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected
         * with a <code>VersionConflictException</code>.
         * </p>
         * 
         * @param expectedVersion
         *        The expected version of the thing record in the registry. If the version of the record in the registry
         *        does not match the expected version specified in the request, the <code>DeleteThing</code> request is
         *        rejected with a <code>VersionConflictException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedVersion(Long expectedVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String thingName;

        private Long expectedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteThingRequest model) {
            setThingName(model.thingName);
            setExpectedVersion(model.expectedVersion);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Long getExpectedVersion() {
            return expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        @Override
        public DeleteThingRequest build() {
            return new DeleteThingRequest(this);
        }
    }
}
