/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the DescribeEndpoint operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeEndpointResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeEndpointResponse.Builder, DescribeEndpointResponse> {
    private final String endpointAddress;

    private DescribeEndpointResponse(BuilderImpl builder) {
        this.endpointAddress = builder.endpointAddress;
    }

    /**
     * <p>
     * The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
     * </p>
     * 
     * @return The endpoint. The format of the endpoint is as follows:
     *         <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
     */
    public String endpointAddress() {
        return endpointAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((endpointAddress() == null) ? 0 : endpointAddress().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointResponse)) {
            return false;
        }
        DescribeEndpointResponse other = (DescribeEndpointResponse) obj;
        if (other.endpointAddress() == null ^ this.endpointAddress() == null) {
            return false;
        }
        if (other.endpointAddress() != null && !other.endpointAddress().equals(this.endpointAddress())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (endpointAddress() != null) {
            sb.append("EndpointAddress: ").append(endpointAddress()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeEndpointResponse> {
        /**
         * <p>
         * The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
         * </p>
         * 
         * @param endpointAddress
         *        The endpoint. The format of the endpoint is as follows:
         *        <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointAddress(String endpointAddress);
    }

    private static final class BuilderImpl implements Builder {
        private String endpointAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointResponse model) {
            setEndpointAddress(model.endpointAddress);
        }

        public final String getEndpointAddress() {
            return endpointAddress;
        }

        @Override
        public final Builder endpointAddress(String endpointAddress) {
            this.endpointAddress = endpointAddress;
            return this;
        }

        public final void setEndpointAddress(String endpointAddress) {
            this.endpointAddress = endpointAddress;
        }

        @Override
        public DescribeEndpointResponse build() {
            return new DescribeEndpointResponse(this);
        }
    }
}
