/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the GetPolicy operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetPolicyResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetPolicyResponse.Builder, GetPolicyResponse> {
    private final String policyName;

    private final String policyArn;

    private final String policyDocument;

    private final String defaultVersionId;

    private GetPolicyResponse(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyArn = builder.policyArn;
        this.policyDocument = builder.policyDocument;
        this.defaultVersionId = builder.defaultVersionId;
    }

    /**
     * <p>
     * The policy name.
     * </p>
     * 
     * @return The policy name.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy ARN.
     * </p>
     * 
     * @return The policy ARN.
     */
    public String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The JSON document that describes the policy.
     * </p>
     * 
     * @return The JSON document that describes the policy.
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The default policy version ID.
     * </p>
     * 
     * @return The default policy version ID.
     */
    public String defaultVersionId() {
        return defaultVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((policyName() == null) ? 0 : policyName().hashCode());
        hashCode = 31 * hashCode + ((policyArn() == null) ? 0 : policyArn().hashCode());
        hashCode = 31 * hashCode + ((policyDocument() == null) ? 0 : policyDocument().hashCode());
        hashCode = 31 * hashCode + ((defaultVersionId() == null) ? 0 : defaultVersionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyResponse)) {
            return false;
        }
        GetPolicyResponse other = (GetPolicyResponse) obj;
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyArn() == null ^ this.policyArn() == null) {
            return false;
        }
        if (other.policyArn() != null && !other.policyArn().equals(this.policyArn())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        if (other.policyDocument() != null && !other.policyDocument().equals(this.policyDocument())) {
            return false;
        }
        if (other.defaultVersionId() == null ^ this.defaultVersionId() == null) {
            return false;
        }
        if (other.defaultVersionId() != null && !other.defaultVersionId().equals(this.defaultVersionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        if (policyArn() != null) {
            sb.append("PolicyArn: ").append(policyArn()).append(",");
        }
        if (policyDocument() != null) {
            sb.append("PolicyDocument: ").append(policyDocument()).append(",");
        }
        if (defaultVersionId() != null) {
            sb.append("DefaultVersionId: ").append(defaultVersionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetPolicyResponse> {
        /**
         * <p>
         * The policy name.
         * </p>
         * 
         * @param policyName
         *        The policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy ARN.
         * </p>
         * 
         * @param policyArn
         *        The policy ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The JSON document that describes the policy.
         * </p>
         * 
         * @param policyDocument
         *        The JSON document that describes the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The default policy version ID.
         * </p>
         * 
         * @param defaultVersionId
         *        The default policy version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionId(String defaultVersionId);
    }

    private static final class BuilderImpl implements Builder {
        private String policyName;

        private String policyArn;

        private String policyDocument;

        private String defaultVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyResponse model) {
            setPolicyName(model.policyName);
            setPolicyArn(model.policyArn);
            setPolicyDocument(model.policyDocument);
            setDefaultVersionId(model.defaultVersionId);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final String getDefaultVersionId() {
            return defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        @Override
        public GetPolicyResponse build() {
            return new GetPolicyResponse(this);
        }
    }
}
