/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the GetPolicyVersion operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetPolicyVersionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetPolicyVersionResponse.Builder, GetPolicyVersionResponse> {
    private final String policyArn;

    private final String policyName;

    private final String policyDocument;

    private final String policyVersionId;

    private final Boolean isDefaultVersion;

    private GetPolicyVersionResponse(BuilderImpl builder) {
        this.policyArn = builder.policyArn;
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.policyVersionId = builder.policyVersionId;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    /**
     * <p>
     * The policy ARN.
     * </p>
     * 
     * @return The policy ARN.
     */
    public String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The policy name.
     * </p>
     * 
     * @return The policy name.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The JSON document that describes the policy.
     * </p>
     * 
     * @return The JSON document that describes the policy.
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The policy version ID.
     * </p>
     * 
     * @return The policy version ID.
     */
    public String policyVersionId() {
        return policyVersionId;
    }

    /**
     * <p>
     * Specifies whether the policy version is the default.
     * </p>
     * 
     * @return Specifies whether the policy version is the default.
     */
    public Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((policyArn() == null) ? 0 : policyArn().hashCode());
        hashCode = 31 * hashCode + ((policyName() == null) ? 0 : policyName().hashCode());
        hashCode = 31 * hashCode + ((policyDocument() == null) ? 0 : policyDocument().hashCode());
        hashCode = 31 * hashCode + ((policyVersionId() == null) ? 0 : policyVersionId().hashCode());
        hashCode = 31 * hashCode + ((isDefaultVersion() == null) ? 0 : isDefaultVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyVersionResponse)) {
            return false;
        }
        GetPolicyVersionResponse other = (GetPolicyVersionResponse) obj;
        if (other.policyArn() == null ^ this.policyArn() == null) {
            return false;
        }
        if (other.policyArn() != null && !other.policyArn().equals(this.policyArn())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        if (other.policyDocument() != null && !other.policyDocument().equals(this.policyDocument())) {
            return false;
        }
        if (other.policyVersionId() == null ^ this.policyVersionId() == null) {
            return false;
        }
        if (other.policyVersionId() != null && !other.policyVersionId().equals(this.policyVersionId())) {
            return false;
        }
        if (other.isDefaultVersion() == null ^ this.isDefaultVersion() == null) {
            return false;
        }
        if (other.isDefaultVersion() != null && !other.isDefaultVersion().equals(this.isDefaultVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (policyArn() != null) {
            sb.append("PolicyArn: ").append(policyArn()).append(",");
        }
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        if (policyDocument() != null) {
            sb.append("PolicyDocument: ").append(policyDocument()).append(",");
        }
        if (policyVersionId() != null) {
            sb.append("PolicyVersionId: ").append(policyVersionId()).append(",");
        }
        if (isDefaultVersion() != null) {
            sb.append("IsDefaultVersion: ").append(isDefaultVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetPolicyVersionResponse> {
        /**
         * <p>
         * The policy ARN.
         * </p>
         * 
         * @param policyArn
         *        The policy ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The policy name.
         * </p>
         * 
         * @param policyName
         *        The policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The JSON document that describes the policy.
         * </p>
         * 
         * @param policyDocument
         *        The JSON document that describes the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The policy version ID.
         * </p>
         * 
         * @param policyVersionId
         *        The policy version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionId(String policyVersionId);

        /**
         * <p>
         * Specifies whether the policy version is the default.
         * </p>
         * 
         * @param isDefaultVersion
         *        Specifies whether the policy version is the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String policyArn;

        private String policyName;

        private String policyDocument;

        private String policyVersionId;

        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyVersionResponse model) {
            setPolicyArn(model.policyArn);
            setPolicyName(model.policyName);
            setPolicyDocument(model.policyDocument);
            setPolicyVersionId(model.policyVersionId);
            setIsDefaultVersion(model.isDefaultVersion);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final String getPolicyVersionId() {
            return policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public GetPolicyVersionResponse build() {
            return new GetPolicyVersionResponse(this);
        }
    }
}
