/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the GetTopicRule operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTopicRuleRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetTopicRuleRequest.Builder, GetTopicRuleRequest> {
    private final String ruleName;

    private GetTopicRuleRequest(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public String ruleName() {
        return ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ruleName() == null) ? 0 : ruleName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTopicRuleRequest)) {
            return false;
        }
        GetTopicRuleRequest other = (GetTopicRuleRequest) obj;
        if (other.ruleName() == null ^ this.ruleName() == null) {
            return false;
        }
        if (other.ruleName() != null && !other.ruleName().equals(this.ruleName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ruleName() != null) {
            sb.append("RuleName: ").append(ruleName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetTopicRuleRequest> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);
    }

    private static final class BuilderImpl implements Builder {
        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTopicRuleRequest model) {
            setRuleName(model.ruleName);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public GetTopicRuleRequest build() {
            return new GetTopicRuleRequest(this);
        }
    }
}
