/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the ListCertificatesByCA operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCertificatesByCAResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListCertificatesByCAResponse.Builder, ListCertificatesByCAResponse> {
    private final List<Certificate> certificates;

    private final String nextMarker;

    private ListCertificatesByCAResponse(BuilderImpl builder) {
        this.certificates = builder.certificates;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The device certificates signed by the specified CA certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The device certificates signed by the specified CA certificate.
     */
    public List<Certificate> certificates() {
        return certificates;
    }

    /**
     * <p>
     * The marker for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The marker for the next set of results, or null if there are no additional results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificates() == null) ? 0 : certificates().hashCode());
        hashCode = 31 * hashCode + ((nextMarker() == null) ? 0 : nextMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesByCAResponse)) {
            return false;
        }
        ListCertificatesByCAResponse other = (ListCertificatesByCAResponse) obj;
        if (other.certificates() == null ^ this.certificates() == null) {
            return false;
        }
        if (other.certificates() != null && !other.certificates().equals(this.certificates())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (certificates() != null) {
            sb.append("Certificates: ").append(certificates()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListCertificatesByCAResponse> {
        /**
         * <p>
         * The device certificates signed by the specified CA certificate.
         * </p>
         * 
         * @param certificates
         *        The device certificates signed by the specified CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<Certificate> certificates);

        /**
         * <p>
         * The device certificates signed by the specified CA certificate.
         * </p>
         * 
         * @param certificates
         *        The device certificates signed by the specified CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Certificate... certificates);

        /**
         * <p>
         * The marker for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextMarker
         *        The marker for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    private static final class BuilderImpl implements Builder {
        private List<Certificate> certificates;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesByCAResponse model) {
            setCertificates(model.certificates);
            setNextMarker(model.nextMarker);
        }

        public final Collection<Certificate> getCertificates() {
            return certificates;
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        public final void setCertificates(Collection<Certificate> certificates) {
            this.certificates = CertificatesCopier.copy(certificates);
        }

        @SafeVarargs
        public final void setCertificates(Certificate... certificates) {
            certificates(Arrays.asList(certificates));
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListCertificatesByCAResponse build() {
            return new ListCertificatesByCAResponse(this);
        }
    }
}
