/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the SetLoggingOptions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetLoggingOptionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetLoggingOptionsRequest.Builder, SetLoggingOptionsRequest> {
    private final LoggingOptionsPayload loggingOptionsPayload;

    private SetLoggingOptionsRequest(BuilderImpl builder) {
        this.loggingOptionsPayload = builder.loggingOptionsPayload;
    }

    /**
     * <p>
     * The logging options payload.
     * </p>
     * 
     * @return The logging options payload.
     */
    public LoggingOptionsPayload loggingOptionsPayload() {
        return loggingOptionsPayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((loggingOptionsPayload() == null) ? 0 : loggingOptionsPayload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoggingOptionsRequest)) {
            return false;
        }
        SetLoggingOptionsRequest other = (SetLoggingOptionsRequest) obj;
        if (other.loggingOptionsPayload() == null ^ this.loggingOptionsPayload() == null) {
            return false;
        }
        if (other.loggingOptionsPayload() != null && !other.loggingOptionsPayload().equals(this.loggingOptionsPayload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (loggingOptionsPayload() != null) {
            sb.append("LoggingOptionsPayload: ").append(loggingOptionsPayload()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SetLoggingOptionsRequest> {
        /**
         * <p>
         * The logging options payload.
         * </p>
         * 
         * @param loggingOptionsPayload
         *        The logging options payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingOptionsPayload(LoggingOptionsPayload loggingOptionsPayload);
    }

    private static final class BuilderImpl implements Builder {
        private LoggingOptionsPayload loggingOptionsPayload;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoggingOptionsRequest model) {
            setLoggingOptionsPayload(model.loggingOptionsPayload);
        }

        public final LoggingOptionsPayload getLoggingOptionsPayload() {
            return loggingOptionsPayload;
        }

        @Override
        public final Builder loggingOptionsPayload(LoggingOptionsPayload loggingOptionsPayload) {
            this.loggingOptionsPayload = loggingOptionsPayload;
            return this;
        }

        public final void setLoggingOptionsPayload(LoggingOptionsPayload loggingOptionsPayload) {
            this.loggingOptionsPayload = loggingOptionsPayload;
        }

        @Override
        public SetLoggingOptionsRequest build() {
            return new SetLoggingOptionsRequest(this);
        }
    }
}
