/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input to the UpdateCACertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateCACertificateRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateCACertificateRequest.Builder, UpdateCACertificateRequest> {
    private final String certificateId;

    private final String newStatus;

    private final String newAutoRegistrationStatus;

    private UpdateCACertificateRequest(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.newStatus = builder.newStatus;
        this.newAutoRegistrationStatus = builder.newAutoRegistrationStatus;
    }

    /**
     * <p>
     * The CA certificate identifier.
     * </p>
     * 
     * @return The CA certificate identifier.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The updated status of the CA certificate.
     * </p>
     * <p>
     * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * </p>
     * 
     * @return The updated status of the CA certificate.</p>
     *         <p>
     *         <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * @see CACertificateStatus
     */
    public String newStatus() {
        return newStatus;
    }

    /**
     * <p>
     * The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
     * </p>
     * 
     * @return The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
     * @see AutoRegistrationStatus
     */
    public String newAutoRegistrationStatus() {
        return newAutoRegistrationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificateId() == null) ? 0 : certificateId().hashCode());
        hashCode = 31 * hashCode + ((newStatus() == null) ? 0 : newStatus().hashCode());
        hashCode = 31 * hashCode + ((newAutoRegistrationStatus() == null) ? 0 : newAutoRegistrationStatus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCACertificateRequest)) {
            return false;
        }
        UpdateCACertificateRequest other = (UpdateCACertificateRequest) obj;
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.newStatus() == null ^ this.newStatus() == null) {
            return false;
        }
        if (other.newStatus() != null && !other.newStatus().equals(this.newStatus())) {
            return false;
        }
        if (other.newAutoRegistrationStatus() == null ^ this.newAutoRegistrationStatus() == null) {
            return false;
        }
        if (other.newAutoRegistrationStatus() != null
                && !other.newAutoRegistrationStatus().equals(this.newAutoRegistrationStatus())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (certificateId() != null) {
            sb.append("CertificateId: ").append(certificateId()).append(",");
        }
        if (newStatus() != null) {
            sb.append("NewStatus: ").append(newStatus()).append(",");
        }
        if (newAutoRegistrationStatus() != null) {
            sb.append("NewAutoRegistrationStatus: ").append(newAutoRegistrationStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateCACertificateRequest> {
        /**
         * <p>
         * The CA certificate identifier.
         * </p>
         * 
         * @param certificateId
         *        The CA certificate identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The updated status of the CA certificate.
         * </p>
         * <p>
         * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param newStatus
         *        The updated status of the CA certificate.</p>
         *        <p>
         *        <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @see CACertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder newStatus(String newStatus);

        /**
         * <p>
         * The updated status of the CA certificate.
         * </p>
         * <p>
         * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param newStatus
         *        The updated status of the CA certificate.</p>
         *        <p>
         *        <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @see CACertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder newStatus(CACertificateStatus newStatus);

        /**
         * <p>
         * The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
         * </p>
         * 
         * @param newAutoRegistrationStatus
         *        The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
         * @see AutoRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRegistrationStatus
         */
        Builder newAutoRegistrationStatus(String newAutoRegistrationStatus);

        /**
         * <p>
         * The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
         * </p>
         * 
         * @param newAutoRegistrationStatus
         *        The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
         * @see AutoRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRegistrationStatus
         */
        Builder newAutoRegistrationStatus(AutoRegistrationStatus newAutoRegistrationStatus);
    }

    private static final class BuilderImpl implements Builder {
        private String certificateId;

        private String newStatus;

        private String newAutoRegistrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCACertificateRequest model) {
            setCertificateId(model.certificateId);
            setNewStatus(model.newStatus);
            setNewAutoRegistrationStatus(model.newAutoRegistrationStatus);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getNewStatus() {
            return newStatus;
        }

        @Override
        public final Builder newStatus(String newStatus) {
            this.newStatus = newStatus;
            return this;
        }

        @Override
        public final Builder newStatus(CACertificateStatus newStatus) {
            this.newStatus(newStatus.toString());
            return this;
        }

        public final void setNewStatus(String newStatus) {
            this.newStatus = newStatus;
        }

        public final void setNewStatus(CACertificateStatus newStatus) {
            this.newStatus(newStatus.toString());
        }

        public final String getNewAutoRegistrationStatus() {
            return newAutoRegistrationStatus;
        }

        @Override
        public final Builder newAutoRegistrationStatus(String newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus = newAutoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder newAutoRegistrationStatus(AutoRegistrationStatus newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus(newAutoRegistrationStatus.toString());
            return this;
        }

        public final void setNewAutoRegistrationStatus(String newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus = newAutoRegistrationStatus;
        }

        public final void setNewAutoRegistrationStatus(AutoRegistrationStatus newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus(newAutoRegistrationStatus.toString());
        }

        @Override
        public UpdateCACertificateRequest build() {
            return new UpdateCACertificateRequest(this);
        }
    }
}
