/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.iot.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * TransferDataMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class TransferDataMarshaller {

    private static final MarshallingInfo<String> TRANSFERMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferMessage").build();
    private static final MarshallingInfo<String> REJECTREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectReason").build();
    private static final MarshallingInfo<java.time.Instant> TRANSFERDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferDate")
            .build();
    private static final MarshallingInfo<java.time.Instant> ACCEPTDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("acceptDate").build();
    private static final MarshallingInfo<java.time.Instant> REJECTDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectDate").build();

    private static final TransferDataMarshaller instance = new TransferDataMarshaller();

    public static TransferDataMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(TransferData transferData, ProtocolMarshaller protocolMarshaller) {

        if (transferData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(transferData.transferMessage(), TRANSFERMESSAGE_BINDING);

            protocolMarshaller.marshall(transferData.rejectReason(), REJECTREASON_BINDING);

            protocolMarshaller.marshall(transferData.transferDate(), TRANSFERDATE_BINDING);

            protocolMarshaller.marshall(transferData.acceptDate(), ACCEPTDATE_BINDING);

            protocolMarshaller.marshall(transferData.rejectDate(), REJECTDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
