/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.transform;

import java.math.*;
import java.nio.ByteBuffer;
import javax.annotation.Generated;

import software.amazon.awssdk.services.iotdataplane.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DeleteThingShadowResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteThingShadowResponseUnmarshaller implements Unmarshaller<DeleteThingShadowResponse, JsonUnmarshallerContext> {

    public DeleteThingShadowResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeleteThingShadowResponse.Builder deleteThingShadowResponseBuilder = DeleteThingShadowResponse.builder();

        java.io.InputStream is = context.getHttpResponse().getContent();
        if (is != null) {
            try {
                deleteThingShadowResponseBuilder.payload(java.nio.ByteBuffer.wrap(software.amazon.awssdk.utils.IoUtils
                        .toByteArray(is)));
            } finally {
                software.amazon.awssdk.utils.IoUtils.closeQuietly(is, null);
            }
        }

        return deleteThingShadowResponseBuilder.build();
    }

    private static DeleteThingShadowResponseUnmarshaller INSTANCE;

    public static DeleteThingShadowResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DeleteThingShadowResponseUnmarshaller();
        return INSTANCE;
    }
}
