/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.DynamoKeyType;
import software.amazon.awssdk.services.iot.transform.DynamoDBActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DynamoDBAction
implements StructuredPojo,
ToCopyableBuilder<Builder, DynamoDBAction> {
    private final String tableName;
    private final String roleArn;
    private final String operation;
    private final String hashKeyField;
    private final String hashKeyValue;
    private final String hashKeyType;
    private final String rangeKeyField;
    private final String rangeKeyValue;
    private final String rangeKeyType;
    private final String payloadField;

    private DynamoDBAction(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.roleArn = builder.roleArn;
        this.operation = builder.operation;
        this.hashKeyField = builder.hashKeyField;
        this.hashKeyValue = builder.hashKeyValue;
        this.hashKeyType = builder.hashKeyType;
        this.rangeKeyField = builder.rangeKeyField;
        this.rangeKeyValue = builder.rangeKeyValue;
        this.rangeKeyType = builder.rangeKeyType;
        this.payloadField = builder.payloadField;
    }

    public String tableName() {
        return this.tableName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String operation() {
        return this.operation;
    }

    public String hashKeyField() {
        return this.hashKeyField;
    }

    public String hashKeyValue() {
        return this.hashKeyValue;
    }

    public String hashKeyType() {
        return this.hashKeyType;
    }

    public String rangeKeyField() {
        return this.rangeKeyField;
    }

    public String rangeKeyValue() {
        return this.rangeKeyValue;
    }

    public String rangeKeyType() {
        return this.rangeKeyType;
    }

    public String payloadField() {
        return this.payloadField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.operation() == null ? 0 : this.operation().hashCode());
        hashCode = 31 * hashCode + (this.hashKeyField() == null ? 0 : this.hashKeyField().hashCode());
        hashCode = 31 * hashCode + (this.hashKeyValue() == null ? 0 : this.hashKeyValue().hashCode());
        hashCode = 31 * hashCode + (this.hashKeyType() == null ? 0 : this.hashKeyType().hashCode());
        hashCode = 31 * hashCode + (this.rangeKeyField() == null ? 0 : this.rangeKeyField().hashCode());
        hashCode = 31 * hashCode + (this.rangeKeyValue() == null ? 0 : this.rangeKeyValue().hashCode());
        hashCode = 31 * hashCode + (this.rangeKeyType() == null ? 0 : this.rangeKeyType().hashCode());
        hashCode = 31 * hashCode + (this.payloadField() == null ? 0 : this.payloadField().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBAction)) {
            return false;
        }
        DynamoDBAction other = (DynamoDBAction)obj;
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.operation() == null ^ this.operation() == null) {
            return false;
        }
        if (other.operation() != null && !other.operation().equals(this.operation())) {
            return false;
        }
        if (other.hashKeyField() == null ^ this.hashKeyField() == null) {
            return false;
        }
        if (other.hashKeyField() != null && !other.hashKeyField().equals(this.hashKeyField())) {
            return false;
        }
        if (other.hashKeyValue() == null ^ this.hashKeyValue() == null) {
            return false;
        }
        if (other.hashKeyValue() != null && !other.hashKeyValue().equals(this.hashKeyValue())) {
            return false;
        }
        if (other.hashKeyType() == null ^ this.hashKeyType() == null) {
            return false;
        }
        if (other.hashKeyType() != null && !other.hashKeyType().equals(this.hashKeyType())) {
            return false;
        }
        if (other.rangeKeyField() == null ^ this.rangeKeyField() == null) {
            return false;
        }
        if (other.rangeKeyField() != null && !other.rangeKeyField().equals(this.rangeKeyField())) {
            return false;
        }
        if (other.rangeKeyValue() == null ^ this.rangeKeyValue() == null) {
            return false;
        }
        if (other.rangeKeyValue() != null && !other.rangeKeyValue().equals(this.rangeKeyValue())) {
            return false;
        }
        if (other.rangeKeyType() == null ^ this.rangeKeyType() == null) {
            return false;
        }
        if (other.rangeKeyType() != null && !other.rangeKeyType().equals(this.rangeKeyType())) {
            return false;
        }
        if (other.payloadField() == null ^ this.payloadField() == null) {
            return false;
        }
        return other.payloadField() == null || other.payloadField().equals(this.payloadField());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.operation() != null) {
            sb.append("Operation: ").append(this.operation()).append(",");
        }
        if (this.hashKeyField() != null) {
            sb.append("HashKeyField: ").append(this.hashKeyField()).append(",");
        }
        if (this.hashKeyValue() != null) {
            sb.append("HashKeyValue: ").append(this.hashKeyValue()).append(",");
        }
        if (this.hashKeyType() != null) {
            sb.append("HashKeyType: ").append(this.hashKeyType()).append(",");
        }
        if (this.rangeKeyField() != null) {
            sb.append("RangeKeyField: ").append(this.rangeKeyField()).append(",");
        }
        if (this.rangeKeyValue() != null) {
            sb.append("RangeKeyValue: ").append(this.rangeKeyValue()).append(",");
        }
        if (this.rangeKeyType() != null) {
            sb.append("RangeKeyType: ").append(this.rangeKeyType()).append(",");
        }
        if (this.payloadField() != null) {
            sb.append("PayloadField: ").append(this.payloadField()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamoDBActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String roleArn;
        private String operation;
        private String hashKeyField;
        private String hashKeyValue;
        private String hashKeyType;
        private String rangeKeyField;
        private String rangeKeyValue;
        private String rangeKeyType;
        private String payloadField;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBAction model) {
            this.setTableName(model.tableName);
            this.setRoleArn(model.roleArn);
            this.setOperation(model.operation);
            this.setHashKeyField(model.hashKeyField);
            this.setHashKeyValue(model.hashKeyValue);
            this.setHashKeyType(model.hashKeyType);
            this.setRangeKeyField(model.rangeKeyField);
            this.setRangeKeyValue(model.rangeKeyValue);
            this.setRangeKeyType(model.rangeKeyType);
            this.setPayloadField(model.payloadField);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final String getHashKeyField() {
            return this.hashKeyField;
        }

        @Override
        public final Builder hashKeyField(String hashKeyField) {
            this.hashKeyField = hashKeyField;
            return this;
        }

        public final void setHashKeyField(String hashKeyField) {
            this.hashKeyField = hashKeyField;
        }

        public final String getHashKeyValue() {
            return this.hashKeyValue;
        }

        @Override
        public final Builder hashKeyValue(String hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
            return this;
        }

        public final void setHashKeyValue(String hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
        }

        public final String getHashKeyType() {
            return this.hashKeyType;
        }

        @Override
        public final Builder hashKeyType(String hashKeyType) {
            this.hashKeyType = hashKeyType;
            return this;
        }

        @Override
        public final Builder hashKeyType(DynamoKeyType hashKeyType) {
            this.hashKeyType(hashKeyType.toString());
            return this;
        }

        public final void setHashKeyType(String hashKeyType) {
            this.hashKeyType = hashKeyType;
        }

        public final void setHashKeyType(DynamoKeyType hashKeyType) {
            this.hashKeyType(hashKeyType.toString());
        }

        public final String getRangeKeyField() {
            return this.rangeKeyField;
        }

        @Override
        public final Builder rangeKeyField(String rangeKeyField) {
            this.rangeKeyField = rangeKeyField;
            return this;
        }

        public final void setRangeKeyField(String rangeKeyField) {
            this.rangeKeyField = rangeKeyField;
        }

        public final String getRangeKeyValue() {
            return this.rangeKeyValue;
        }

        @Override
        public final Builder rangeKeyValue(String rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
            return this;
        }

        public final void setRangeKeyValue(String rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
        }

        public final String getRangeKeyType() {
            return this.rangeKeyType;
        }

        @Override
        public final Builder rangeKeyType(String rangeKeyType) {
            this.rangeKeyType = rangeKeyType;
            return this;
        }

        @Override
        public final Builder rangeKeyType(DynamoKeyType rangeKeyType) {
            this.rangeKeyType(rangeKeyType.toString());
            return this;
        }

        public final void setRangeKeyType(String rangeKeyType) {
            this.rangeKeyType = rangeKeyType;
        }

        public final void setRangeKeyType(DynamoKeyType rangeKeyType) {
            this.rangeKeyType(rangeKeyType.toString());
        }

        public final String getPayloadField() {
            return this.payloadField;
        }

        @Override
        public final Builder payloadField(String payloadField) {
            this.payloadField = payloadField;
            return this;
        }

        public final void setPayloadField(String payloadField) {
            this.payloadField = payloadField;
        }

        public DynamoDBAction build() {
            return new DynamoDBAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DynamoDBAction> {
        public Builder tableName(String var1);

        public Builder roleArn(String var1);

        public Builder operation(String var1);

        public Builder hashKeyField(String var1);

        public Builder hashKeyValue(String var1);

        public Builder hashKeyType(String var1);

        public Builder hashKeyType(DynamoKeyType var1);

        public Builder rangeKeyField(String var1);

        public Builder rangeKeyValue(String var1);

        public Builder rangeKeyType(String var1);

        public Builder rangeKeyType(DynamoKeyType var1);

        public Builder payloadField(String var1);
    }
}

