/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.OutgoingCertificateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OutgoingCertificate
implements StructuredPojo,
ToCopyableBuilder<Builder, OutgoingCertificate> {
    private final String certificateArn;
    private final String certificateId;
    private final String transferredTo;
    private final Instant transferDate;
    private final String transferMessage;
    private final Instant creationDate;

    private OutgoingCertificate(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.transferredTo = builder.transferredTo;
        this.transferDate = builder.transferDate;
        this.transferMessage = builder.transferMessage;
        this.creationDate = builder.creationDate;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String transferredTo() {
        return this.transferredTo;
    }

    public Instant transferDate() {
        return this.transferDate;
    }

    public String transferMessage() {
        return this.transferMessage;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateArn() == null ? 0 : this.certificateArn().hashCode());
        hashCode = 31 * hashCode + (this.certificateId() == null ? 0 : this.certificateId().hashCode());
        hashCode = 31 * hashCode + (this.transferredTo() == null ? 0 : this.transferredTo().hashCode());
        hashCode = 31 * hashCode + (this.transferDate() == null ? 0 : this.transferDate().hashCode());
        hashCode = 31 * hashCode + (this.transferMessage() == null ? 0 : this.transferMessage().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutgoingCertificate)) {
            return false;
        }
        OutgoingCertificate other = (OutgoingCertificate)obj;
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.transferredTo() == null ^ this.transferredTo() == null) {
            return false;
        }
        if (other.transferredTo() != null && !other.transferredTo().equals(this.transferredTo())) {
            return false;
        }
        if (other.transferDate() == null ^ this.transferDate() == null) {
            return false;
        }
        if (other.transferDate() != null && !other.transferDate().equals(this.transferDate())) {
            return false;
        }
        if (other.transferMessage() == null ^ this.transferMessage() == null) {
            return false;
        }
        if (other.transferMessage() != null && !other.transferMessage().equals(this.transferMessage())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        return other.creationDate() == null || other.creationDate().equals(this.creationDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateArn() != null) {
            sb.append("CertificateArn: ").append(this.certificateArn()).append(",");
        }
        if (this.certificateId() != null) {
            sb.append("CertificateId: ").append(this.certificateId()).append(",");
        }
        if (this.transferredTo() != null) {
            sb.append("TransferredTo: ").append(this.transferredTo()).append(",");
        }
        if (this.transferDate() != null) {
            sb.append("TransferDate: ").append(this.transferDate()).append(",");
        }
        if (this.transferMessage() != null) {
            sb.append("TransferMessage: ").append(this.transferMessage()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutgoingCertificateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateId;
        private String transferredTo;
        private Instant transferDate;
        private String transferMessage;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OutgoingCertificate model) {
            this.setCertificateArn(model.certificateArn);
            this.setCertificateId(model.certificateId);
            this.setTransferredTo(model.transferredTo);
            this.setTransferDate(model.transferDate);
            this.setTransferMessage(model.transferMessage);
            this.setCreationDate(model.creationDate);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getTransferredTo() {
            return this.transferredTo;
        }

        @Override
        public final Builder transferredTo(String transferredTo) {
            this.transferredTo = transferredTo;
            return this;
        }

        public final void setTransferredTo(String transferredTo) {
            this.transferredTo = transferredTo;
        }

        public final Instant getTransferDate() {
            return this.transferDate;
        }

        @Override
        public final Builder transferDate(Instant transferDate) {
            this.transferDate = transferDate;
            return this;
        }

        public final void setTransferDate(Instant transferDate) {
            this.transferDate = transferDate;
        }

        public final String getTransferMessage() {
            return this.transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public OutgoingCertificate build() {
            return new OutgoingCertificate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutgoingCertificate> {
        public Builder certificateArn(String var1);

        public Builder certificateId(String var1);

        public Builder transferredTo(String var1);

        public Builder transferDate(Instant var1);

        public Builder transferMessage(String var1);

        public Builder creationDate(Instant var1);
    }
}

