/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TopicRuleListItem;

@SdkInternalApi
public class TopicRuleListItemMarshaller {
    private static final MarshallingInfo<String> RULEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleArn").build();
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleName").build();
    private static final MarshallingInfo<String> TOPICPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("topicPattern").build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<Boolean> RULEDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleDisabled").build();
    private static final TopicRuleListItemMarshaller instance = new TopicRuleListItemMarshaller();

    public static TopicRuleListItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(TopicRuleListItem topicRuleListItem, ProtocolMarshaller protocolMarshaller) {
        if (topicRuleListItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)topicRuleListItem.ruleArn(), RULEARN_BINDING);
            protocolMarshaller.marshall((Object)topicRuleListItem.ruleName(), RULENAME_BINDING);
            protocolMarshaller.marshall((Object)topicRuleListItem.topicPattern(), TOPICPATTERN_BINDING);
            protocolMarshaller.marshall((Object)topicRuleListItem.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)topicRuleListItem.ruleDisabled(), RULEDISABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

