/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CertificateDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CertificateDescription implements StructuredPojo,
        ToCopyableBuilder<CertificateDescription.Builder, CertificateDescription> {
    private final String certificateArn;

    private final String certificateId;

    private final String caCertificateId;

    private final String status;

    private final String certificatePem;

    private final String ownedBy;

    private final String previousOwnedBy;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final TransferData transferData;

    private CertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.caCertificateId = builder.caCertificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.previousOwnedBy = builder.previousOwnedBy;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.transferData = builder.transferData;
    }

    /**
     * <p>
     * The ARN of the certificate.
     * </p>
     * 
     * @return The ARN of the certificate.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The ID of the certificate.
     * </p>
     * 
     * @return The ID of the certificate.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The certificate ID of the CA certificate used to sign this certificate.
     * </p>
     * 
     * @return The certificate ID of the CA certificate used to sign this certificate.
     */
    public String caCertificateId() {
        return caCertificateId;
    }

    /**
     * <p>
     * The status of the certificate.
     * </p>
     * 
     * @return The status of the certificate.
     * @see CertificateStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The certificate data, in PEM format.
     * </p>
     * 
     * @return The certificate data, in PEM format.
     */
    public String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the certificate.
     * </p>
     * 
     * @return The ID of the AWS account that owns the certificate.
     */
    public String ownedBy() {
        return ownedBy;
    }

    /**
     * <p>
     * The ID of the AWS account of the previous owner of the certificate.
     * </p>
     * 
     * @return The ID of the AWS account of the previous owner of the certificate.
     */
    public String previousOwnedBy() {
        return previousOwnedBy;
    }

    /**
     * <p>
     * The date and time the certificate was created.
     * </p>
     * 
     * @return The date and time the certificate was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time the certificate was last modified.
     * </p>
     * 
     * @return The date and time the certificate was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The transfer data.
     * </p>
     * 
     * @return The transfer data.
     */
    public TransferData transferData() {
        return transferData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificateArn() == null) ? 0 : certificateArn().hashCode());
        hashCode = 31 * hashCode + ((certificateId() == null) ? 0 : certificateId().hashCode());
        hashCode = 31 * hashCode + ((caCertificateId() == null) ? 0 : caCertificateId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((certificatePem() == null) ? 0 : certificatePem().hashCode());
        hashCode = 31 * hashCode + ((ownedBy() == null) ? 0 : ownedBy().hashCode());
        hashCode = 31 * hashCode + ((previousOwnedBy() == null) ? 0 : previousOwnedBy().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((lastModifiedDate() == null) ? 0 : lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + ((transferData() == null) ? 0 : transferData().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateDescription)) {
            return false;
        }
        CertificateDescription other = (CertificateDescription) obj;
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.caCertificateId() == null ^ this.caCertificateId() == null) {
            return false;
        }
        if (other.caCertificateId() != null && !other.caCertificateId().equals(this.caCertificateId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.certificatePem() == null ^ this.certificatePem() == null) {
            return false;
        }
        if (other.certificatePem() != null && !other.certificatePem().equals(this.certificatePem())) {
            return false;
        }
        if (other.ownedBy() == null ^ this.ownedBy() == null) {
            return false;
        }
        if (other.ownedBy() != null && !other.ownedBy().equals(this.ownedBy())) {
            return false;
        }
        if (other.previousOwnedBy() == null ^ this.previousOwnedBy() == null) {
            return false;
        }
        if (other.previousOwnedBy() != null && !other.previousOwnedBy().equals(this.previousOwnedBy())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.transferData() == null ^ this.transferData() == null) {
            return false;
        }
        if (other.transferData() != null && !other.transferData().equals(this.transferData())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (certificateArn() != null) {
            sb.append("CertificateArn: ").append(certificateArn()).append(",");
        }
        if (certificateId() != null) {
            sb.append("CertificateId: ").append(certificateId()).append(",");
        }
        if (caCertificateId() != null) {
            sb.append("CaCertificateId: ").append(caCertificateId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (certificatePem() != null) {
            sb.append("CertificatePem: ").append(certificatePem()).append(",");
        }
        if (ownedBy() != null) {
            sb.append("OwnedBy: ").append(ownedBy()).append(",");
        }
        if (previousOwnedBy() != null) {
            sb.append("PreviousOwnedBy: ").append(previousOwnedBy()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(lastModifiedDate()).append(",");
        }
        if (transferData() != null) {
            sb.append("TransferData: ").append(transferData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CertificateDescription> {
        /**
         * <p>
         * The ARN of the certificate.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The ID of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The certificate ID of the CA certificate used to sign this certificate.
         * </p>
         * 
         * @param caCertificateId
         *        The certificate ID of the CA certificate used to sign this certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateId(String caCertificateId);

        /**
         * <p>
         * The status of the certificate.
         * </p>
         * 
         * @param status
         *        The status of the certificate.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the certificate.
         * </p>
         * 
         * @param status
         *        The status of the certificate.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(CertificateStatus status);

        /**
         * <p>
         * The certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The ID of the AWS account that owns the certificate.
         * </p>
         * 
         * @param ownedBy
         *        The ID of the AWS account that owns the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownedBy(String ownedBy);

        /**
         * <p>
         * The ID of the AWS account of the previous owner of the certificate.
         * </p>
         * 
         * @param previousOwnedBy
         *        The ID of the AWS account of the previous owner of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousOwnedBy(String previousOwnedBy);

        /**
         * <p>
         * The date and time the certificate was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time the certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time the certificate was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time the certificate was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The transfer data.
         * </p>
         * 
         * @param transferData
         *        The transfer data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferData(TransferData transferData);
    }

    private static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String caCertificateId;

        private String status;

        private String certificatePem;

        private String ownedBy;

        private String previousOwnedBy;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private TransferData transferData;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateDescription model) {
            setCertificateArn(model.certificateArn);
            setCertificateId(model.certificateId);
            setCaCertificateId(model.caCertificateId);
            setStatus(model.status);
            setCertificatePem(model.certificatePem);
            setOwnedBy(model.ownedBy);
            setPreviousOwnedBy(model.previousOwnedBy);
            setCreationDate(model.creationDate);
            setLastModifiedDate(model.lastModifiedDate);
            setTransferData(model.transferData);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCaCertificateId() {
            return caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getOwnedBy() {
            return ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        public final String getPreviousOwnedBy() {
            return previousOwnedBy;
        }

        @Override
        public final Builder previousOwnedBy(String previousOwnedBy) {
            this.previousOwnedBy = previousOwnedBy;
            return this;
        }

        public final void setPreviousOwnedBy(String previousOwnedBy) {
            this.previousOwnedBy = previousOwnedBy;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final TransferData getTransferData() {
            return transferData;
        }

        @Override
        public final Builder transferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public final void setTransferData(TransferData transferData) {
            this.transferData = transferData;
        }

        @Override
        public CertificateDescription build() {
            return new CertificateDescription(this);
        }
    }
}
