/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the TransferCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TransferCertificateRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<TransferCertificateRequest.Builder, TransferCertificateRequest> {
    private final String certificateId;

    private final String targetAwsAccount;

    private final String transferMessage;

    private TransferCertificateRequest(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.targetAwsAccount = builder.targetAwsAccount;
        this.transferMessage = builder.transferMessage;
    }

    /**
     * <p>
     * The ID of the certificate.
     * </p>
     * 
     * @return The ID of the certificate.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The AWS account.
     * </p>
     * 
     * @return The AWS account.
     */
    public String targetAwsAccount() {
        return targetAwsAccount;
    }

    /**
     * <p>
     * The transfer message.
     * </p>
     * 
     * @return The transfer message.
     */
    public String transferMessage() {
        return transferMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificateId() == null) ? 0 : certificateId().hashCode());
        hashCode = 31 * hashCode + ((targetAwsAccount() == null) ? 0 : targetAwsAccount().hashCode());
        hashCode = 31 * hashCode + ((transferMessage() == null) ? 0 : transferMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferCertificateRequest)) {
            return false;
        }
        TransferCertificateRequest other = (TransferCertificateRequest) obj;
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.targetAwsAccount() == null ^ this.targetAwsAccount() == null) {
            return false;
        }
        if (other.targetAwsAccount() != null && !other.targetAwsAccount().equals(this.targetAwsAccount())) {
            return false;
        }
        if (other.transferMessage() == null ^ this.transferMessage() == null) {
            return false;
        }
        if (other.transferMessage() != null && !other.transferMessage().equals(this.transferMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (certificateId() != null) {
            sb.append("CertificateId: ").append(certificateId()).append(",");
        }
        if (targetAwsAccount() != null) {
            sb.append("TargetAwsAccount: ").append(targetAwsAccount()).append(",");
        }
        if (transferMessage() != null) {
            sb.append("TransferMessage: ").append(transferMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TransferCertificateRequest> {
        /**
         * <p>
         * The ID of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The AWS account.
         * </p>
         * 
         * @param targetAwsAccount
         *        The AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAwsAccount(String targetAwsAccount);

        /**
         * <p>
         * The transfer message.
         * </p>
         * 
         * @param transferMessage
         *        The transfer message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferMessage(String transferMessage);
    }

    private static final class BuilderImpl implements Builder {
        private String certificateId;

        private String targetAwsAccount;

        private String transferMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferCertificateRequest model) {
            setCertificateId(model.certificateId);
            setTargetAwsAccount(model.targetAwsAccount);
            setTransferMessage(model.transferMessage);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getTargetAwsAccount() {
            return targetAwsAccount;
        }

        @Override
        public final Builder targetAwsAccount(String targetAwsAccount) {
            this.targetAwsAccount = targetAwsAccount;
            return this;
        }

        public final void setTargetAwsAccount(String targetAwsAccount) {
            this.targetAwsAccount = targetAwsAccount;
        }

        public final String getTransferMessage() {
            return transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        @Override
        public TransferCertificateRequest build() {
            return new TransferCertificateRequest(this);
        }
    }
}
