/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.TransferDataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data used to transfer a certificate to an AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TransferData implements StructuredPojo, ToCopyableBuilder<TransferData.Builder, TransferData> {
    private final String transferMessage;

    private final String rejectReason;

    private final Instant transferDate;

    private final Instant acceptDate;

    private final Instant rejectDate;

    private TransferData(BuilderImpl builder) {
        this.transferMessage = builder.transferMessage;
        this.rejectReason = builder.rejectReason;
        this.transferDate = builder.transferDate;
        this.acceptDate = builder.acceptDate;
        this.rejectDate = builder.rejectDate;
    }

    /**
     * <p>
     * The transfer message.
     * </p>
     * 
     * @return The transfer message.
     */
    public String transferMessage() {
        return transferMessage;
    }

    /**
     * <p>
     * The reason why the transfer was rejected.
     * </p>
     * 
     * @return The reason why the transfer was rejected.
     */
    public String rejectReason() {
        return rejectReason;
    }

    /**
     * <p>
     * The date the transfer took place.
     * </p>
     * 
     * @return The date the transfer took place.
     */
    public Instant transferDate() {
        return transferDate;
    }

    /**
     * <p>
     * The date the transfer was accepted.
     * </p>
     * 
     * @return The date the transfer was accepted.
     */
    public Instant acceptDate() {
        return acceptDate;
    }

    /**
     * <p>
     * The date the transfer was rejected.
     * </p>
     * 
     * @return The date the transfer was rejected.
     */
    public Instant rejectDate() {
        return rejectDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((transferMessage() == null) ? 0 : transferMessage().hashCode());
        hashCode = 31 * hashCode + ((rejectReason() == null) ? 0 : rejectReason().hashCode());
        hashCode = 31 * hashCode + ((transferDate() == null) ? 0 : transferDate().hashCode());
        hashCode = 31 * hashCode + ((acceptDate() == null) ? 0 : acceptDate().hashCode());
        hashCode = 31 * hashCode + ((rejectDate() == null) ? 0 : rejectDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferData)) {
            return false;
        }
        TransferData other = (TransferData) obj;
        if (other.transferMessage() == null ^ this.transferMessage() == null) {
            return false;
        }
        if (other.transferMessage() != null && !other.transferMessage().equals(this.transferMessage())) {
            return false;
        }
        if (other.rejectReason() == null ^ this.rejectReason() == null) {
            return false;
        }
        if (other.rejectReason() != null && !other.rejectReason().equals(this.rejectReason())) {
            return false;
        }
        if (other.transferDate() == null ^ this.transferDate() == null) {
            return false;
        }
        if (other.transferDate() != null && !other.transferDate().equals(this.transferDate())) {
            return false;
        }
        if (other.acceptDate() == null ^ this.acceptDate() == null) {
            return false;
        }
        if (other.acceptDate() != null && !other.acceptDate().equals(this.acceptDate())) {
            return false;
        }
        if (other.rejectDate() == null ^ this.rejectDate() == null) {
            return false;
        }
        if (other.rejectDate() != null && !other.rejectDate().equals(this.rejectDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (transferMessage() != null) {
            sb.append("TransferMessage: ").append(transferMessage()).append(",");
        }
        if (rejectReason() != null) {
            sb.append("RejectReason: ").append(rejectReason()).append(",");
        }
        if (transferDate() != null) {
            sb.append("TransferDate: ").append(transferDate()).append(",");
        }
        if (acceptDate() != null) {
            sb.append("AcceptDate: ").append(acceptDate()).append(",");
        }
        if (rejectDate() != null) {
            sb.append("RejectDate: ").append(rejectDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransferDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TransferData> {
        /**
         * <p>
         * The transfer message.
         * </p>
         * 
         * @param transferMessage
         *        The transfer message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferMessage(String transferMessage);

        /**
         * <p>
         * The reason why the transfer was rejected.
         * </p>
         * 
         * @param rejectReason
         *        The reason why the transfer was rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectReason(String rejectReason);

        /**
         * <p>
         * The date the transfer took place.
         * </p>
         * 
         * @param transferDate
         *        The date the transfer took place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferDate(Instant transferDate);

        /**
         * <p>
         * The date the transfer was accepted.
         * </p>
         * 
         * @param acceptDate
         *        The date the transfer was accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptDate(Instant acceptDate);

        /**
         * <p>
         * The date the transfer was rejected.
         * </p>
         * 
         * @param rejectDate
         *        The date the transfer was rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectDate(Instant rejectDate);
    }

    private static final class BuilderImpl implements Builder {
        private String transferMessage;

        private String rejectReason;

        private Instant transferDate;

        private Instant acceptDate;

        private Instant rejectDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferData model) {
            setTransferMessage(model.transferMessage);
            setRejectReason(model.rejectReason);
            setTransferDate(model.transferDate);
            setAcceptDate(model.acceptDate);
            setRejectDate(model.rejectDate);
        }

        public final String getTransferMessage() {
            return transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        public final String getRejectReason() {
            return rejectReason;
        }

        @Override
        public final Builder rejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
            return this;
        }

        public final void setRejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
        }

        public final Instant getTransferDate() {
            return transferDate;
        }

        @Override
        public final Builder transferDate(Instant transferDate) {
            this.transferDate = transferDate;
            return this;
        }

        public final void setTransferDate(Instant transferDate) {
            this.transferDate = transferDate;
        }

        public final Instant getAcceptDate() {
            return acceptDate;
        }

        @Override
        public final Builder acceptDate(Instant acceptDate) {
            this.acceptDate = acceptDate;
            return this;
        }

        public final void setAcceptDate(Instant acceptDate) {
            this.acceptDate = acceptDate;
        }

        public final Instant getRejectDate() {
            return rejectDate;
        }

        @Override
        public final Builder rejectDate(Instant rejectDate) {
            this.rejectDate = rejectDate;
            return this;
        }

        public final void setRejectDate(Instant rejectDate) {
            this.rejectDate = rejectDate;
        }

        @Override
        public TransferData build() {
            return new TransferData(this);
        }
    }
}
