/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DynamoDBAction JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DynamoDBActionUnmarshaller implements Unmarshaller<DynamoDBAction, JsonUnmarshallerContext> {

    public DynamoDBAction unmarshall(JsonUnmarshallerContext context) throws Exception {
        DynamoDBAction.Builder dynamoDBActionBuilder = DynamoDBAction.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("tableName", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.tableName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.roleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("operation", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.operation(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("hashKeyField", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.hashKeyField(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("hashKeyValue", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.hashKeyValue(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("hashKeyType", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.hashKeyType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("rangeKeyField", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.rangeKeyField(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("rangeKeyValue", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.rangeKeyValue(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("rangeKeyType", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.rangeKeyType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("payloadField", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.payloadField(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return dynamoDBActionBuilder.build();
    }

    private static final DynamoDBActionUnmarshaller INSTANCE = new DynamoDBActionUnmarshaller();

    public static DynamoDBActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
