/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.ThingNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPrincipalThingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPrincipalThingsResponse> {
    private final List<String> things;
    private final String nextToken;

    private ListPrincipalThingsResponse(BuilderImpl builder) {
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    public List<String> things() {
        return this.things;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.things() == null ? 0 : this.things().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalThingsResponse)) {
            return false;
        }
        ListPrincipalThingsResponse other = (ListPrincipalThingsResponse)((Object)obj);
        if (other.things() == null ^ this.things() == null) {
            return false;
        }
        if (other.things() != null && !other.things().equals(this.things())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.things() != null) {
            sb.append("Things: ").append(this.things()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> things;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalThingsResponse model) {
            this.setThings(model.things);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getThings() {
            return this.things;
        }

        @Override
        public final Builder things(Collection<String> things) {
            this.things = ThingNameListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(String ... things) {
            this.things(Arrays.asList(things));
            return this;
        }

        public final void setThings(Collection<String> things) {
            this.things = ThingNameListCopier.copy(things);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListPrincipalThingsResponse build() {
            return new ListPrincipalThingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPrincipalThingsResponse> {
        public Builder things(Collection<String> var1);

        public Builder things(String ... var1);

        public Builder nextToken(String var1);
    }
}

