/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.DynamoDBv2Action;

@SdkInternalApi
public class DynamoDBv2ActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<StructuredPojo> PUTITEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("putItem").build();
    private static final DynamoDBv2ActionMarshaller INSTANCE = new DynamoDBv2ActionMarshaller();

    public static DynamoDBv2ActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DynamoDBv2Action dynamoDBv2Action, ProtocolMarshaller protocolMarshaller) {
        if (dynamoDBv2Action == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dynamoDBv2Action.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBv2Action.putItem(), PUTITEM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

