/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.KeyPair;

@SdkInternalApi
public class KeyPairMarshaller {
    private static final MarshallingInfo<String> PUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicKey").build();
    private static final MarshallingInfo<String> PRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateKey").build();
    private static final KeyPairMarshaller INSTANCE = new KeyPairMarshaller();

    public static KeyPairMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyPair keyPair, ProtocolMarshaller protocolMarshaller) {
        if (keyPair == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)keyPair.publicKey(), PUBLICKEY_BINDING);
            protocolMarshaller.marshall((Object)keyPair.privateKey(), PRIVATEKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

