/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.KinesisAction;

public class KinesisActionUnmarshaller
implements Unmarshaller<KinesisAction, JsonUnmarshallerContext> {
    private static final KinesisActionUnmarshaller INSTANCE = new KinesisActionUnmarshaller();

    public KinesisAction unmarshall(JsonUnmarshallerContext context) throws Exception {
        KinesisAction.Builder kinesisActionBuilder = KinesisAction.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    kinesisActionBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("streamName", targetDepth)) {
                    context.nextToken();
                    kinesisActionBuilder.streamName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("partitionKey", targetDepth)) {
                    context.nextToken();
                    kinesisActionBuilder.partitionKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KinesisAction)kinesisActionBuilder.build();
    }

    public static KinesisActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

