/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.S3Action;

public class S3ActionUnmarshaller
implements Unmarshaller<S3Action, JsonUnmarshallerContext> {
    private static final S3ActionUnmarshaller INSTANCE = new S3ActionUnmarshaller();

    public S3Action unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Action.Builder s3ActionBuilder = S3Action.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    s3ActionBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("bucketName", targetDepth)) {
                    context.nextToken();
                    s3ActionBuilder.bucketName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("key", targetDepth)) {
                    context.nextToken();
                    s3ActionBuilder.key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("cannedAcl", targetDepth)) {
                    context.nextToken();
                    s3ActionBuilder.cannedAcl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3Action)s3ActionBuilder.build();
    }

    public static S3ActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

