/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreateThingType operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateThingTypeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateThingTypeRequest.Builder, CreateThingTypeRequest> {
    private final String thingTypeName;

    private final ThingTypeProperties thingTypeProperties;

    private CreateThingTypeRequest(BuilderImpl builder) {
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeProperties = builder.thingTypeProperties;
    }

    /**
     * <p>
     * The name of the thing type.
     * </p>
     * 
     * @return The name of the thing type.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The ThingTypeProperties for the thing type to create. It contains information about the new thing type including
     * a description, and a list of searchable thing attribute names.
     * </p>
     * 
     * @return The ThingTypeProperties for the thing type to create. It contains information about the new thing type
     *         including a description, and a list of searchable thing attribute names.
     */
    public ThingTypeProperties thingTypeProperties() {
        return thingTypeProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((thingTypeName() == null) ? 0 : thingTypeName().hashCode());
        hashCode = 31 * hashCode + ((thingTypeProperties() == null) ? 0 : thingTypeProperties().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingTypeRequest)) {
            return false;
        }
        CreateThingTypeRequest other = (CreateThingTypeRequest) obj;
        if (other.thingTypeName() == null ^ this.thingTypeName() == null) {
            return false;
        }
        if (other.thingTypeName() != null && !other.thingTypeName().equals(this.thingTypeName())) {
            return false;
        }
        if (other.thingTypeProperties() == null ^ this.thingTypeProperties() == null) {
            return false;
        }
        if (other.thingTypeProperties() != null && !other.thingTypeProperties().equals(this.thingTypeProperties())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(thingTypeName()).append(",");
        }
        if (thingTypeProperties() != null) {
            sb.append("ThingTypeProperties: ").append(thingTypeProperties()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateThingTypeRequest> {
        /**
         * <p>
         * The name of the thing type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The ThingTypeProperties for the thing type to create. It contains information about the new thing type
         * including a description, and a list of searchable thing attribute names.
         * </p>
         * 
         * @param thingTypeProperties
         *        The ThingTypeProperties for the thing type to create. It contains information about the new thing type
         *        including a description, and a list of searchable thing attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeProperties(ThingTypeProperties thingTypeProperties);
    }

    private static final class BuilderImpl implements Builder {
        private String thingTypeName;

        private ThingTypeProperties thingTypeProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingTypeRequest model) {
            setThingTypeName(model.thingTypeName);
            setThingTypeProperties(model.thingTypeProperties);
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final ThingTypeProperties getThingTypeProperties() {
            return thingTypeProperties;
        }

        @Override
        public final Builder thingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        public final void setThingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
        }

        @Override
        public CreateThingTypeRequest build() {
            return new CreateThingTypeRequest(this);
        }
    }
}
