/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListTopicRules operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTopicRulesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListTopicRulesResponse.Builder, ListTopicRulesResponse> {
    private final List<TopicRuleListItem> rules;

    private final String nextToken;

    private ListTopicRulesResponse(BuilderImpl builder) {
        this.rules = builder.rules;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The rules.
     */
    public List<TopicRuleListItem> rules() {
        return rules;
    }

    /**
     * <p>
     * A token used to retrieve the next value.
     * </p>
     * 
     * @return A token used to retrieve the next value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((rules() == null) ? 0 : rules().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicRulesResponse)) {
            return false;
        }
        ListTopicRulesResponse other = (ListTopicRulesResponse) obj;
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        if (other.rules() != null && !other.rules().equals(this.rules())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (rules() != null) {
            sb.append("Rules: ").append(rules()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTopicRulesResponse> {
        /**
         * <p>
         * The rules.
         * </p>
         * 
         * @param rules
         *        The rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<TopicRuleListItem> rules);

        /**
         * <p>
         * The rules.
         * </p>
         * 
         * @param rules
         *        The rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(TopicRuleListItem... rules);

        /**
         * <p>
         * A token used to retrieve the next value.
         * </p>
         * 
         * @param nextToken
         *        A token used to retrieve the next value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<TopicRuleListItem> rules;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicRulesResponse model) {
            setRules(model.rules);
            setNextToken(model.nextToken);
        }

        public final Collection<TopicRuleListItem> getRules() {
            return rules;
        }

        @Override
        public final Builder rules(Collection<TopicRuleListItem> rules) {
            this.rules = TopicRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(TopicRuleListItem... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<TopicRuleListItem> rules) {
            this.rules = TopicRuleListCopier.copy(rules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTopicRulesResponse build() {
            return new ListTopicRulesResponse(this);
        }
    }
}
