/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource already exists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceAlreadyExistsException extends IoTException implements
        ToCopyableBuilder<ResourceAlreadyExistsException.Builder, ResourceAlreadyExistsException> {
    private final String resourceId;

    private final String resourceArn;

    private ResourceAlreadyExistsException(BuilderImpl builder) {
        super(builder.message);
        this.resourceId = builder.resourceId;
        this.resourceArn = builder.resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The ID of the resource that caused the exception.
     * </p>
     * 
     * @return The ID of the resource that caused the exception.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The ARN of the resource that caused the exception.
     * </p>
     * 
     * @return The ARN of the resource that caused the exception.
     */
    public String resourceArn() {
        return resourceArn;
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceAlreadyExistsException> {
        /**
         * <p>
         * The ID of the resource that caused the exception.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource that caused the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The ARN of the resource that caused the exception.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource that caused the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceId;

        private String resourceArn;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceAlreadyExistsException model) {
            setResourceId(model.resourceId);
            setResourceArn(model.resourceArn);
            this.message = model.getMessage();
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @JsonProperty("resourceId")
        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @JsonProperty("resourceArn")
        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ResourceAlreadyExistsException build() {
            return new ResourceAlreadyExistsException(this);
        }
    }
}
