/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ThingTypeDefinitionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of the thing type, including thing type name and description.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ThingTypeDefinition implements StructuredPojo, ToCopyableBuilder<ThingTypeDefinition.Builder, ThingTypeDefinition> {
    private final String thingTypeName;

    private final ThingTypeProperties thingTypeProperties;

    private final ThingTypeMetadata thingTypeMetadata;

    private ThingTypeDefinition(BuilderImpl builder) {
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeProperties = builder.thingTypeProperties;
        this.thingTypeMetadata = builder.thingTypeMetadata;
    }

    /**
     * <p>
     * The name of the thing type.
     * </p>
     * 
     * @return The name of the thing type.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The ThingTypeProperties for the thing type.
     * </p>
     * 
     * @return The ThingTypeProperties for the thing type.
     */
    public ThingTypeProperties thingTypeProperties() {
        return thingTypeProperties;
    }

    /**
     * <p>
     * The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a
     * value indicating whether the thing type is deprecated, and a date and time when it was deprecated.
     * </p>
     * 
     * @return The ThingTypeMetadata contains additional information about the thing type including: creation date and
     *         time, a value indicating whether the thing type is deprecated, and a date and time when it was
     *         deprecated.
     */
    public ThingTypeMetadata thingTypeMetadata() {
        return thingTypeMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((thingTypeName() == null) ? 0 : thingTypeName().hashCode());
        hashCode = 31 * hashCode + ((thingTypeProperties() == null) ? 0 : thingTypeProperties().hashCode());
        hashCode = 31 * hashCode + ((thingTypeMetadata() == null) ? 0 : thingTypeMetadata().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeDefinition)) {
            return false;
        }
        ThingTypeDefinition other = (ThingTypeDefinition) obj;
        if (other.thingTypeName() == null ^ this.thingTypeName() == null) {
            return false;
        }
        if (other.thingTypeName() != null && !other.thingTypeName().equals(this.thingTypeName())) {
            return false;
        }
        if (other.thingTypeProperties() == null ^ this.thingTypeProperties() == null) {
            return false;
        }
        if (other.thingTypeProperties() != null && !other.thingTypeProperties().equals(this.thingTypeProperties())) {
            return false;
        }
        if (other.thingTypeMetadata() == null ^ this.thingTypeMetadata() == null) {
            return false;
        }
        if (other.thingTypeMetadata() != null && !other.thingTypeMetadata().equals(this.thingTypeMetadata())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(thingTypeName()).append(",");
        }
        if (thingTypeProperties() != null) {
            sb.append("ThingTypeProperties: ").append(thingTypeProperties()).append(",");
        }
        if (thingTypeMetadata() != null) {
            sb.append("ThingTypeMetadata: ").append(thingTypeMetadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingTypeDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ThingTypeDefinition> {
        /**
         * <p>
         * The name of the thing type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The ThingTypeProperties for the thing type.
         * </p>
         * 
         * @param thingTypeProperties
         *        The ThingTypeProperties for the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeProperties(ThingTypeProperties thingTypeProperties);

        /**
         * <p>
         * The ThingTypeMetadata contains additional information about the thing type including: creation date and time,
         * a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.
         * </p>
         * 
         * @param thingTypeMetadata
         *        The ThingTypeMetadata contains additional information about the thing type including: creation date
         *        and time, a value indicating whether the thing type is deprecated, and a date and time when it was
         *        deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeMetadata(ThingTypeMetadata thingTypeMetadata);
    }

    private static final class BuilderImpl implements Builder {
        private String thingTypeName;

        private ThingTypeProperties thingTypeProperties;

        private ThingTypeMetadata thingTypeMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeDefinition model) {
            setThingTypeName(model.thingTypeName);
            setThingTypeProperties(model.thingTypeProperties);
            setThingTypeMetadata(model.thingTypeMetadata);
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final ThingTypeProperties getThingTypeProperties() {
            return thingTypeProperties;
        }

        @Override
        public final Builder thingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        public final void setThingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
        }

        public final ThingTypeMetadata getThingTypeMetadata() {
            return thingTypeMetadata;
        }

        @Override
        public final Builder thingTypeMetadata(ThingTypeMetadata thingTypeMetadata) {
            this.thingTypeMetadata = thingTypeMetadata;
            return this;
        }

        public final void setThingTypeMetadata(ThingTypeMetadata thingTypeMetadata) {
            this.thingTypeMetadata = thingTypeMetadata;
        }

        @Override
        public ThingTypeDefinition build() {
            return new ThingTypeDefinition(this);
        }
    }
}
