/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CertificateStatus;
import software.amazon.awssdk.services.iot.model.TransferData;
import software.amazon.awssdk.services.iot.transform.CertificateDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CertificateDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, CertificateDescription> {
    private final String certificateArn;
    private final String certificateId;
    private final String caCertificateId;
    private final String status;
    private final String certificatePem;
    private final String ownedBy;
    private final String previousOwnedBy;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final TransferData transferData;

    private CertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.caCertificateId = builder.caCertificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.previousOwnedBy = builder.previousOwnedBy;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.transferData = builder.transferData;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String caCertificateId() {
        return this.caCertificateId;
    }

    public String status() {
        return this.status;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public String ownedBy() {
        return this.ownedBy;
    }

    public String previousOwnedBy() {
        return this.previousOwnedBy;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public TransferData transferData() {
        return this.transferData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateArn() == null ? 0 : this.certificateArn().hashCode());
        hashCode = 31 * hashCode + (this.certificateId() == null ? 0 : this.certificateId().hashCode());
        hashCode = 31 * hashCode + (this.caCertificateId() == null ? 0 : this.caCertificateId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.certificatePem() == null ? 0 : this.certificatePem().hashCode());
        hashCode = 31 * hashCode + (this.ownedBy() == null ? 0 : this.ownedBy().hashCode());
        hashCode = 31 * hashCode + (this.previousOwnedBy() == null ? 0 : this.previousOwnedBy().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.transferData() == null ? 0 : this.transferData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateDescription)) {
            return false;
        }
        CertificateDescription other = (CertificateDescription)obj;
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.caCertificateId() == null ^ this.caCertificateId() == null) {
            return false;
        }
        if (other.caCertificateId() != null && !other.caCertificateId().equals(this.caCertificateId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.certificatePem() == null ^ this.certificatePem() == null) {
            return false;
        }
        if (other.certificatePem() != null && !other.certificatePem().equals(this.certificatePem())) {
            return false;
        }
        if (other.ownedBy() == null ^ this.ownedBy() == null) {
            return false;
        }
        if (other.ownedBy() != null && !other.ownedBy().equals(this.ownedBy())) {
            return false;
        }
        if (other.previousOwnedBy() == null ^ this.previousOwnedBy() == null) {
            return false;
        }
        if (other.previousOwnedBy() != null && !other.previousOwnedBy().equals(this.previousOwnedBy())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.transferData() == null ^ this.transferData() == null) {
            return false;
        }
        return other.transferData() == null || other.transferData().equals(this.transferData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateArn() != null) {
            sb.append("CertificateArn: ").append(this.certificateArn()).append(",");
        }
        if (this.certificateId() != null) {
            sb.append("CertificateId: ").append(this.certificateId()).append(",");
        }
        if (this.caCertificateId() != null) {
            sb.append("CaCertificateId: ").append(this.caCertificateId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.certificatePem() != null) {
            sb.append("CertificatePem: ").append(this.certificatePem()).append(",");
        }
        if (this.ownedBy() != null) {
            sb.append("OwnedBy: ").append(this.ownedBy()).append(",");
        }
        if (this.previousOwnedBy() != null) {
            sb.append("PreviousOwnedBy: ").append(this.previousOwnedBy()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.transferData() != null) {
            sb.append("TransferData: ").append(this.transferData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateId;
        private String caCertificateId;
        private String status;
        private String certificatePem;
        private String ownedBy;
        private String previousOwnedBy;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private TransferData transferData;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateDescription model) {
            this.setCertificateArn(model.certificateArn);
            this.setCertificateId(model.certificateId);
            this.setCaCertificateId(model.caCertificateId);
            this.setStatus(model.status);
            this.setCertificatePem(model.certificatePem);
            this.setOwnedBy(model.ownedBy);
            this.setPreviousOwnedBy(model.previousOwnedBy);
            this.setCreationDate(model.creationDate);
            this.setLastModifiedDate(model.lastModifiedDate);
            this.setTransferData(model.transferData);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCaCertificateId() {
            return this.caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getOwnedBy() {
            return this.ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        public final String getPreviousOwnedBy() {
            return this.previousOwnedBy;
        }

        @Override
        public final Builder previousOwnedBy(String previousOwnedBy) {
            this.previousOwnedBy = previousOwnedBy;
            return this;
        }

        public final void setPreviousOwnedBy(String previousOwnedBy) {
            this.previousOwnedBy = previousOwnedBy;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final TransferData getTransferData() {
            return this.transferData;
        }

        @Override
        public final Builder transferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public final void setTransferData(TransferData transferData) {
            this.transferData = transferData;
        }

        public CertificateDescription build() {
            return new CertificateDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CertificateDescription> {
        public Builder certificateArn(String var1);

        public Builder certificateId(String var1);

        public Builder caCertificateId(String var1);

        public Builder status(String var1);

        public Builder status(CertificateStatus var1);

        public Builder certificatePem(String var1);

        public Builder ownedBy(String var1);

        public Builder previousOwnedBy(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder transferData(TransferData var1);
    }
}

