/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.PutItemInput;
import software.amazon.awssdk.services.iot.transform.DynamoDBv2ActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DynamoDBv2Action
implements StructuredPojo,
ToCopyableBuilder<Builder, DynamoDBv2Action> {
    private final String roleArn;
    private final PutItemInput putItem;

    private DynamoDBv2Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.putItem = builder.putItem;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public PutItemInput putItem() {
        return this.putItem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.putItem() == null ? 0 : this.putItem().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBv2Action)) {
            return false;
        }
        DynamoDBv2Action other = (DynamoDBv2Action)obj;
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.putItem() == null ^ this.putItem() == null) {
            return false;
        }
        return other.putItem() == null || other.putItem().equals(this.putItem());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.putItem() != null) {
            sb.append("PutItem: ").append(this.putItem()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamoDBv2ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private PutItemInput putItem;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBv2Action model) {
            this.setRoleArn(model.roleArn);
            this.setPutItem(model.putItem);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final PutItemInput getPutItem() {
            return this.putItem;
        }

        @Override
        public final Builder putItem(PutItemInput putItem) {
            this.putItem = putItem;
            return this;
        }

        public final void setPutItem(PutItemInput putItem) {
            this.putItem = putItem;
        }

        public DynamoDBv2Action build() {
            return new DynamoDBv2Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DynamoDBv2Action> {
        public Builder roleArn(String var1);

        public Builder putItem(PutItemInput var1);
    }
}

