/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.KeyPairMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeyPair
implements StructuredPojo,
ToCopyableBuilder<Builder, KeyPair> {
    private final String publicKey;
    private final String privateKey;

    private KeyPair(BuilderImpl builder) {
        this.publicKey = builder.publicKey;
        this.privateKey = builder.privateKey;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.publicKey() == null ? 0 : this.publicKey().hashCode());
        hashCode = 31 * hashCode + (this.privateKey() == null ? 0 : this.privateKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair)obj;
        if (other.publicKey() == null ^ this.publicKey() == null) {
            return false;
        }
        if (other.publicKey() != null && !other.publicKey().equals(this.publicKey())) {
            return false;
        }
        if (other.privateKey() == null ^ this.privateKey() == null) {
            return false;
        }
        return other.privateKey() == null || other.privateKey().equals(this.privateKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.publicKey() != null) {
            sb.append("PublicKey: ").append(this.publicKey()).append(",");
        }
        if (this.privateKey() != null) {
            sb.append("PrivateKey: ").append(this.privateKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyPairMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String publicKey;
        private String privateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPair model) {
            this.setPublicKey(model.publicKey);
            this.setPrivateKey(model.privateKey);
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public KeyPair build() {
            return new KeyPair(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyPair> {
        public Builder publicKey(String var1);

        public Builder privateKey(String var1);
    }
}

