/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.PrincipalsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPolicyPrincipalsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPolicyPrincipalsResponse> {
    private final List<String> principals;
    private final String nextMarker;

    private ListPolicyPrincipalsResponse(BuilderImpl builder) {
        this.principals = builder.principals;
        this.nextMarker = builder.nextMarker;
    }

    public List<String> principals() {
        return this.principals;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.principals() == null ? 0 : this.principals().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyPrincipalsResponse)) {
            return false;
        }
        ListPolicyPrincipalsResponse other = (ListPolicyPrincipalsResponse)((Object)obj);
        if (other.principals() == null ^ this.principals() == null) {
            return false;
        }
        if (other.principals() != null && !other.principals().equals(this.principals())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.principals() != null) {
            sb.append("Principals: ").append(this.principals()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> principals;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyPrincipalsResponse model) {
            this.setPrincipals(model.principals);
            this.setNextMarker(model.nextMarker);
        }

        public final Collection<String> getPrincipals() {
            return this.principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public ListPolicyPrincipalsResponse build() {
            return new ListPolicyPrincipalsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPolicyPrincipalsResponse> {
        public Builder principals(Collection<String> var1);

        public Builder principals(String ... var1);

        public Builder nextMarker(String var1);
    }
}

