/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum MessageFormat {
    RAW("RAW"),
    JSON("JSON");

    private final String value;

    private MessageFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static MessageFormat fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(MessageFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

