/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.Action;
import software.amazon.awssdk.services.iot.model.ActionListCopier;
import software.amazon.awssdk.services.iot.transform.TopicRulePayloadMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TopicRulePayload
implements StructuredPojo,
ToCopyableBuilder<Builder, TopicRulePayload> {
    private final String sql;
    private final String description;
    private final List<Action> actions;
    private final Boolean ruleDisabled;
    private final String awsIotSqlVersion;

    private TopicRulePayload(BuilderImpl builder) {
        this.sql = builder.sql;
        this.description = builder.description;
        this.actions = builder.actions;
        this.ruleDisabled = builder.ruleDisabled;
        this.awsIotSqlVersion = builder.awsIotSqlVersion;
    }

    public String sql() {
        return this.sql;
    }

    public String description() {
        return this.description;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public Boolean ruleDisabled() {
        return this.ruleDisabled;
    }

    public String awsIotSqlVersion() {
        return this.awsIotSqlVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sql() == null ? 0 : this.sql().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.actions() == null ? 0 : this.actions().hashCode());
        hashCode = 31 * hashCode + (this.ruleDisabled() == null ? 0 : this.ruleDisabled().hashCode());
        hashCode = 31 * hashCode + (this.awsIotSqlVersion() == null ? 0 : this.awsIotSqlVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRulePayload)) {
            return false;
        }
        TopicRulePayload other = (TopicRulePayload)obj;
        if (other.sql() == null ^ this.sql() == null) {
            return false;
        }
        if (other.sql() != null && !other.sql().equals(this.sql())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.actions() == null ^ this.actions() == null) {
            return false;
        }
        if (other.actions() != null && !other.actions().equals(this.actions())) {
            return false;
        }
        if (other.ruleDisabled() == null ^ this.ruleDisabled() == null) {
            return false;
        }
        if (other.ruleDisabled() != null && !other.ruleDisabled().equals(this.ruleDisabled())) {
            return false;
        }
        if (other.awsIotSqlVersion() == null ^ this.awsIotSqlVersion() == null) {
            return false;
        }
        return other.awsIotSqlVersion() == null || other.awsIotSqlVersion().equals(this.awsIotSqlVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sql() != null) {
            sb.append("Sql: ").append(this.sql()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.actions() != null) {
            sb.append("Actions: ").append(this.actions()).append(",");
        }
        if (this.ruleDisabled() != null) {
            sb.append("RuleDisabled: ").append(this.ruleDisabled()).append(",");
        }
        if (this.awsIotSqlVersion() != null) {
            sb.append("AwsIotSqlVersion: ").append(this.awsIotSqlVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicRulePayloadMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String sql;
        private String description;
        private List<Action> actions;
        private Boolean ruleDisabled;
        private String awsIotSqlVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRulePayload model) {
            this.setSql(model.sql);
            this.setDescription(model.description);
            this.setActions(model.actions);
            this.setRuleDisabled(model.ruleDisabled);
            this.setAwsIotSqlVersion(model.awsIotSqlVersion);
        }

        public final String getSql() {
            return this.sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Action> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
        }

        public final Boolean getRuleDisabled() {
            return this.ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        public final String getAwsIotSqlVersion() {
            return this.awsIotSqlVersion;
        }

        @Override
        public final Builder awsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
            return this;
        }

        public final void setAwsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
        }

        public TopicRulePayload build() {
            return new TopicRulePayload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TopicRulePayload> {
        public Builder sql(String var1);

        public Builder description(String var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder ruleDisabled(Boolean var1);

        public Builder awsIotSqlVersion(String var1);
    }
}

