/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.FirehoseAction;

public class FirehoseActionUnmarshaller
implements Unmarshaller<FirehoseAction, JsonUnmarshallerContext> {
    private static final FirehoseActionUnmarshaller INSTANCE = new FirehoseActionUnmarshaller();

    public FirehoseAction unmarshall(JsonUnmarshallerContext context) throws Exception {
        FirehoseAction.Builder firehoseActionBuilder = FirehoseAction.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    firehoseActionBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("deliveryStreamName", targetDepth)) {
                    context.nextToken();
                    firehoseActionBuilder.deliveryStreamName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("separator", targetDepth)) {
                    context.nextToken();
                    firehoseActionBuilder.separator((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (FirehoseAction)firehoseActionBuilder.build();
    }

    public static FirehoseActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

