/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.PolicyVersion;

@SdkInternalApi
public class PolicyVersionMarshaller {
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionId").build();
    private static final MarshallingInfo<Boolean> ISDEFAULTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isDefaultVersion").build();
    private static final MarshallingInfo<Instant> CREATEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createDate").build();
    private static final PolicyVersionMarshaller INSTANCE = new PolicyVersionMarshaller();

    public static PolicyVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicyVersion policyVersion, ProtocolMarshaller protocolMarshaller) {
        if (policyVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)policyVersion.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)policyVersion.isDefaultVersion(), ISDEFAULTVERSION_BINDING);
            protocolMarshaller.marshall((Object)policyVersion.createDate(), CREATEDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

