/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.SnsAction;

@SdkInternalApi
public class SnsActionMarshaller {
    private static final MarshallingInfo<String> TARGETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetArn").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<String> MESSAGEFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("messageFormat").build();
    private static final SnsActionMarshaller INSTANCE = new SnsActionMarshaller();

    public static SnsActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SnsAction snsAction, ProtocolMarshaller protocolMarshaller) {
        if (snsAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)snsAction.targetArn(), TARGETARN_BINDING);
            protocolMarshaller.marshall((Object)snsAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)snsAction.messageFormat(), MESSAGEFORMAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

