/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ThingAttribute;

@SdkInternalApi
public class ThingAttributeMarshaller {
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").build();
    private static final MarshallingInfo<String> THINGTYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingTypeName").build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final ThingAttributeMarshaller INSTANCE = new ThingAttributeMarshaller();

    public static ThingAttributeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ThingAttribute thingAttribute, ProtocolMarshaller protocolMarshaller) {
        if (thingAttribute == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)thingAttribute.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall((Object)thingAttribute.thingTypeName(), THINGTYPENAME_BINDING);
            protocolMarshaller.marshall(thingAttribute.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)thingAttribute.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

