/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the actions associated with a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Action implements StructuredPojo, ToCopyableBuilder<Action.Builder, Action> {
    private final DynamoDBAction dynamoDB;

    private final DynamoDBv2Action dynamoDBv2;

    private final LambdaAction lambda;

    private final SnsAction sns;

    private final SqsAction sqs;

    private final KinesisAction kinesis;

    private final RepublishAction republish;

    private final S3Action s3;

    private final FirehoseAction firehose;

    private final CloudwatchMetricAction cloudwatchMetric;

    private final CloudwatchAlarmAction cloudwatchAlarm;

    private final ElasticsearchAction elasticsearch;

    private final SalesforceAction salesforce;

    private Action(BuilderImpl builder) {
        this.dynamoDB = builder.dynamoDB;
        this.dynamoDBv2 = builder.dynamoDBv2;
        this.lambda = builder.lambda;
        this.sns = builder.sns;
        this.sqs = builder.sqs;
        this.kinesis = builder.kinesis;
        this.republish = builder.republish;
        this.s3 = builder.s3;
        this.firehose = builder.firehose;
        this.cloudwatchMetric = builder.cloudwatchMetric;
        this.cloudwatchAlarm = builder.cloudwatchAlarm;
        this.elasticsearch = builder.elasticsearch;
        this.salesforce = builder.salesforce;
    }

    /**
     * <p>
     * Write to a DynamoDB table.
     * </p>
     * 
     * @return Write to a DynamoDB table.
     */
    public DynamoDBAction dynamoDB() {
        return dynamoDB;
    }

    /**
     * <p>
     * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each attribute in
     * an MQTT message payload into a separate DynamoDB column.
     * </p>
     * 
     * @return Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
     *         attribute in an MQTT message payload into a separate DynamoDB column.
     */
    public DynamoDBv2Action dynamoDBv2() {
        return dynamoDBv2;
    }

    /**
     * <p>
     * Invoke a Lambda function.
     * </p>
     * 
     * @return Invoke a Lambda function.
     */
    public LambdaAction lambda() {
        return lambda;
    }

    /**
     * <p>
     * Publish to an Amazon SNS topic.
     * </p>
     * 
     * @return Publish to an Amazon SNS topic.
     */
    public SnsAction sns() {
        return sns;
    }

    /**
     * <p>
     * Publish to an Amazon SQS queue.
     * </p>
     * 
     * @return Publish to an Amazon SQS queue.
     */
    public SqsAction sqs() {
        return sqs;
    }

    /**
     * <p>
     * Write data to an Amazon Kinesis stream.
     * </p>
     * 
     * @return Write data to an Amazon Kinesis stream.
     */
    public KinesisAction kinesis() {
        return kinesis;
    }

    /**
     * <p>
     * Publish to another MQTT topic.
     * </p>
     * 
     * @return Publish to another MQTT topic.
     */
    public RepublishAction republish() {
        return republish;
    }

    /**
     * <p>
     * Write to an Amazon S3 bucket.
     * </p>
     * 
     * @return Write to an Amazon S3 bucket.
     */
    public S3Action s3() {
        return s3;
    }

    /**
     * <p>
     * Write to an Amazon Kinesis Firehose stream.
     * </p>
     * 
     * @return Write to an Amazon Kinesis Firehose stream.
     */
    public FirehoseAction firehose() {
        return firehose;
    }

    /**
     * <p>
     * Capture a CloudWatch metric.
     * </p>
     * 
     * @return Capture a CloudWatch metric.
     */
    public CloudwatchMetricAction cloudwatchMetric() {
        return cloudwatchMetric;
    }

    /**
     * <p>
     * Change the state of a CloudWatch alarm.
     * </p>
     * 
     * @return Change the state of a CloudWatch alarm.
     */
    public CloudwatchAlarmAction cloudwatchAlarm() {
        return cloudwatchAlarm;
    }

    /**
     * <p>
     * Write data to an Amazon Elasticsearch Service domain.
     * </p>
     * 
     * @return Write data to an Amazon Elasticsearch Service domain.
     */
    public ElasticsearchAction elasticsearch() {
        return elasticsearch;
    }

    /**
     * <p>
     * Send a message to a Salesforce IoT Cloud Input Stream.
     * </p>
     * 
     * @return Send a message to a Salesforce IoT Cloud Input Stream.
     */
    public SalesforceAction salesforce() {
        return salesforce;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dynamoDB() == null) ? 0 : dynamoDB().hashCode());
        hashCode = 31 * hashCode + ((dynamoDBv2() == null) ? 0 : dynamoDBv2().hashCode());
        hashCode = 31 * hashCode + ((lambda() == null) ? 0 : lambda().hashCode());
        hashCode = 31 * hashCode + ((sns() == null) ? 0 : sns().hashCode());
        hashCode = 31 * hashCode + ((sqs() == null) ? 0 : sqs().hashCode());
        hashCode = 31 * hashCode + ((kinesis() == null) ? 0 : kinesis().hashCode());
        hashCode = 31 * hashCode + ((republish() == null) ? 0 : republish().hashCode());
        hashCode = 31 * hashCode + ((s3() == null) ? 0 : s3().hashCode());
        hashCode = 31 * hashCode + ((firehose() == null) ? 0 : firehose().hashCode());
        hashCode = 31 * hashCode + ((cloudwatchMetric() == null) ? 0 : cloudwatchMetric().hashCode());
        hashCode = 31 * hashCode + ((cloudwatchAlarm() == null) ? 0 : cloudwatchAlarm().hashCode());
        hashCode = 31 * hashCode + ((elasticsearch() == null) ? 0 : elasticsearch().hashCode());
        hashCode = 31 * hashCode + ((salesforce() == null) ? 0 : salesforce().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        if (other.dynamoDB() == null ^ this.dynamoDB() == null) {
            return false;
        }
        if (other.dynamoDB() != null && !other.dynamoDB().equals(this.dynamoDB())) {
            return false;
        }
        if (other.dynamoDBv2() == null ^ this.dynamoDBv2() == null) {
            return false;
        }
        if (other.dynamoDBv2() != null && !other.dynamoDBv2().equals(this.dynamoDBv2())) {
            return false;
        }
        if (other.lambda() == null ^ this.lambda() == null) {
            return false;
        }
        if (other.lambda() != null && !other.lambda().equals(this.lambda())) {
            return false;
        }
        if (other.sns() == null ^ this.sns() == null) {
            return false;
        }
        if (other.sns() != null && !other.sns().equals(this.sns())) {
            return false;
        }
        if (other.sqs() == null ^ this.sqs() == null) {
            return false;
        }
        if (other.sqs() != null && !other.sqs().equals(this.sqs())) {
            return false;
        }
        if (other.kinesis() == null ^ this.kinesis() == null) {
            return false;
        }
        if (other.kinesis() != null && !other.kinesis().equals(this.kinesis())) {
            return false;
        }
        if (other.republish() == null ^ this.republish() == null) {
            return false;
        }
        if (other.republish() != null && !other.republish().equals(this.republish())) {
            return false;
        }
        if (other.s3() == null ^ this.s3() == null) {
            return false;
        }
        if (other.s3() != null && !other.s3().equals(this.s3())) {
            return false;
        }
        if (other.firehose() == null ^ this.firehose() == null) {
            return false;
        }
        if (other.firehose() != null && !other.firehose().equals(this.firehose())) {
            return false;
        }
        if (other.cloudwatchMetric() == null ^ this.cloudwatchMetric() == null) {
            return false;
        }
        if (other.cloudwatchMetric() != null && !other.cloudwatchMetric().equals(this.cloudwatchMetric())) {
            return false;
        }
        if (other.cloudwatchAlarm() == null ^ this.cloudwatchAlarm() == null) {
            return false;
        }
        if (other.cloudwatchAlarm() != null && !other.cloudwatchAlarm().equals(this.cloudwatchAlarm())) {
            return false;
        }
        if (other.elasticsearch() == null ^ this.elasticsearch() == null) {
            return false;
        }
        if (other.elasticsearch() != null && !other.elasticsearch().equals(this.elasticsearch())) {
            return false;
        }
        if (other.salesforce() == null ^ this.salesforce() == null) {
            return false;
        }
        if (other.salesforce() != null && !other.salesforce().equals(this.salesforce())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dynamoDB() != null) {
            sb.append("DynamoDB: ").append(dynamoDB()).append(",");
        }
        if (dynamoDBv2() != null) {
            sb.append("DynamoDBv2: ").append(dynamoDBv2()).append(",");
        }
        if (lambda() != null) {
            sb.append("Lambda: ").append(lambda()).append(",");
        }
        if (sns() != null) {
            sb.append("Sns: ").append(sns()).append(",");
        }
        if (sqs() != null) {
            sb.append("Sqs: ").append(sqs()).append(",");
        }
        if (kinesis() != null) {
            sb.append("Kinesis: ").append(kinesis()).append(",");
        }
        if (republish() != null) {
            sb.append("Republish: ").append(republish()).append(",");
        }
        if (s3() != null) {
            sb.append("S3: ").append(s3()).append(",");
        }
        if (firehose() != null) {
            sb.append("Firehose: ").append(firehose()).append(",");
        }
        if (cloudwatchMetric() != null) {
            sb.append("CloudwatchMetric: ").append(cloudwatchMetric()).append(",");
        }
        if (cloudwatchAlarm() != null) {
            sb.append("CloudwatchAlarm: ").append(cloudwatchAlarm()).append(",");
        }
        if (elasticsearch() != null) {
            sb.append("Elasticsearch: ").append(elasticsearch()).append(",");
        }
        if (salesforce() != null) {
            sb.append("Salesforce: ").append(salesforce()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dynamoDB":
            return Optional.of(clazz.cast(dynamoDB()));
        case "dynamoDBv2":
            return Optional.of(clazz.cast(dynamoDBv2()));
        case "lambda":
            return Optional.of(clazz.cast(lambda()));
        case "sns":
            return Optional.of(clazz.cast(sns()));
        case "sqs":
            return Optional.of(clazz.cast(sqs()));
        case "kinesis":
            return Optional.of(clazz.cast(kinesis()));
        case "republish":
            return Optional.of(clazz.cast(republish()));
        case "s3":
            return Optional.of(clazz.cast(s3()));
        case "firehose":
            return Optional.of(clazz.cast(firehose()));
        case "cloudwatchMetric":
            return Optional.of(clazz.cast(cloudwatchMetric()));
        case "cloudwatchAlarm":
            return Optional.of(clazz.cast(cloudwatchAlarm()));
        case "elasticsearch":
            return Optional.of(clazz.cast(elasticsearch()));
        case "salesforce":
            return Optional.of(clazz.cast(salesforce()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * Write to a DynamoDB table.
         * </p>
         * 
         * @param dynamoDB
         *        Write to a DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDB(DynamoDBAction dynamoDB);

        /**
         * <p>
         * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
         * attribute in an MQTT message payload into a separate DynamoDB column.
         * </p>
         * 
         * @param dynamoDBv2
         *        Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
         *        attribute in an MQTT message payload into a separate DynamoDB column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2);

        /**
         * <p>
         * Invoke a Lambda function.
         * </p>
         * 
         * @param lambda
         *        Invoke a Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(LambdaAction lambda);

        /**
         * <p>
         * Publish to an Amazon SNS topic.
         * </p>
         * 
         * @param sns
         *        Publish to an Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sns(SnsAction sns);

        /**
         * <p>
         * Publish to an Amazon SQS queue.
         * </p>
         * 
         * @param sqs
         *        Publish to an Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqs(SqsAction sqs);

        /**
         * <p>
         * Write data to an Amazon Kinesis stream.
         * </p>
         * 
         * @param kinesis
         *        Write data to an Amazon Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesis(KinesisAction kinesis);

        /**
         * <p>
         * Publish to another MQTT topic.
         * </p>
         * 
         * @param republish
         *        Publish to another MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder republish(RepublishAction republish);

        /**
         * <p>
         * Write to an Amazon S3 bucket.
         * </p>
         * 
         * @param s3
         *        Write to an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3Action s3);

        /**
         * <p>
         * Write to an Amazon Kinesis Firehose stream.
         * </p>
         * 
         * @param firehose
         *        Write to an Amazon Kinesis Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehose(FirehoseAction firehose);

        /**
         * <p>
         * Capture a CloudWatch metric.
         * </p>
         * 
         * @param cloudwatchMetric
         *        Capture a CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchMetric(CloudwatchMetricAction cloudwatchMetric);

        /**
         * <p>
         * Change the state of a CloudWatch alarm.
         * </p>
         * 
         * @param cloudwatchAlarm
         *        Change the state of a CloudWatch alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchAlarm(CloudwatchAlarmAction cloudwatchAlarm);

        /**
         * <p>
         * Write data to an Amazon Elasticsearch Service domain.
         * </p>
         * 
         * @param elasticsearch
         *        Write data to an Amazon Elasticsearch Service domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearch(ElasticsearchAction elasticsearch);

        /**
         * <p>
         * Send a message to a Salesforce IoT Cloud Input Stream.
         * </p>
         * 
         * @param salesforce
         *        Send a message to a Salesforce IoT Cloud Input Stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforce(SalesforceAction salesforce);
    }

    static final class BuilderImpl implements Builder {
        private DynamoDBAction dynamoDB;

        private DynamoDBv2Action dynamoDBv2;

        private LambdaAction lambda;

        private SnsAction sns;

        private SqsAction sqs;

        private KinesisAction kinesis;

        private RepublishAction republish;

        private S3Action s3;

        private FirehoseAction firehose;

        private CloudwatchMetricAction cloudwatchMetric;

        private CloudwatchAlarmAction cloudwatchAlarm;

        private ElasticsearchAction elasticsearch;

        private SalesforceAction salesforce;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            dynamoDB(model.dynamoDB);
            dynamoDBv2(model.dynamoDBv2);
            lambda(model.lambda);
            sns(model.sns);
            sqs(model.sqs);
            kinesis(model.kinesis);
            republish(model.republish);
            s3(model.s3);
            firehose(model.firehose);
            cloudwatchMetric(model.cloudwatchMetric);
            cloudwatchAlarm(model.cloudwatchAlarm);
            elasticsearch(model.elasticsearch);
            salesforce(model.salesforce);
        }

        public final DynamoDBAction.Builder getDynamoDB() {
            return dynamoDB != null ? dynamoDB.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDB(DynamoDBAction dynamoDB) {
            this.dynamoDB = dynamoDB;
            return this;
        }

        public final void setDynamoDB(DynamoDBAction.BuilderImpl dynamoDB) {
            this.dynamoDB = dynamoDB != null ? dynamoDB.build() : null;
        }

        public final DynamoDBv2Action.Builder getDynamoDBv2() {
            return dynamoDBv2 != null ? dynamoDBv2.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2;
            return this;
        }

        public final void setDynamoDBv2(DynamoDBv2Action.BuilderImpl dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2 != null ? dynamoDBv2.build() : null;
        }

        public final LambdaAction.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        @Override
        public final Builder lambda(LambdaAction lambda) {
            this.lambda = lambda;
            return this;
        }

        public final void setLambda(LambdaAction.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        public final SnsAction.Builder getSns() {
            return sns != null ? sns.toBuilder() : null;
        }

        @Override
        public final Builder sns(SnsAction sns) {
            this.sns = sns;
            return this;
        }

        public final void setSns(SnsAction.BuilderImpl sns) {
            this.sns = sns != null ? sns.build() : null;
        }

        public final SqsAction.Builder getSqs() {
            return sqs != null ? sqs.toBuilder() : null;
        }

        @Override
        public final Builder sqs(SqsAction sqs) {
            this.sqs = sqs;
            return this;
        }

        public final void setSqs(SqsAction.BuilderImpl sqs) {
            this.sqs = sqs != null ? sqs.build() : null;
        }

        public final KinesisAction.Builder getKinesis() {
            return kinesis != null ? kinesis.toBuilder() : null;
        }

        @Override
        public final Builder kinesis(KinesisAction kinesis) {
            this.kinesis = kinesis;
            return this;
        }

        public final void setKinesis(KinesisAction.BuilderImpl kinesis) {
            this.kinesis = kinesis != null ? kinesis.build() : null;
        }

        public final RepublishAction.Builder getRepublish() {
            return republish != null ? republish.toBuilder() : null;
        }

        @Override
        public final Builder republish(RepublishAction republish) {
            this.republish = republish;
            return this;
        }

        public final void setRepublish(RepublishAction.BuilderImpl republish) {
            this.republish = republish != null ? republish.build() : null;
        }

        public final S3Action.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3Action s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3Action.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        public final FirehoseAction.Builder getFirehose() {
            return firehose != null ? firehose.toBuilder() : null;
        }

        @Override
        public final Builder firehose(FirehoseAction firehose) {
            this.firehose = firehose;
            return this;
        }

        public final void setFirehose(FirehoseAction.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        public final CloudwatchMetricAction.Builder getCloudwatchMetric() {
            return cloudwatchMetric != null ? cloudwatchMetric.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchMetric(CloudwatchMetricAction cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric;
            return this;
        }

        public final void setCloudwatchMetric(CloudwatchMetricAction.BuilderImpl cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric != null ? cloudwatchMetric.build() : null;
        }

        public final CloudwatchAlarmAction.Builder getCloudwatchAlarm() {
            return cloudwatchAlarm != null ? cloudwatchAlarm.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchAlarm(CloudwatchAlarmAction cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm;
            return this;
        }

        public final void setCloudwatchAlarm(CloudwatchAlarmAction.BuilderImpl cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm != null ? cloudwatchAlarm.build() : null;
        }

        public final ElasticsearchAction.Builder getElasticsearch() {
            return elasticsearch != null ? elasticsearch.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearch(ElasticsearchAction elasticsearch) {
            this.elasticsearch = elasticsearch;
            return this;
        }

        public final void setElasticsearch(ElasticsearchAction.BuilderImpl elasticsearch) {
            this.elasticsearch = elasticsearch != null ? elasticsearch.build() : null;
        }

        public final SalesforceAction.Builder getSalesforce() {
            return salesforce != null ? salesforce.toBuilder() : null;
        }

        @Override
        public final Builder salesforce(SalesforceAction salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final void setSalesforce(SalesforceAction.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        @Override
        public Action build() {
            return new Action(this);
        }
    }
}
